/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface SystemAccessControl {
    default public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        AccessDeniedException.denyImpersonateUser(context.getIdentity().getUser(), userName);
    }

    @Deprecated
    default public void checkCanSetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, userName);
    }

    default public void checkCanExecuteQuery(SystemSecurityContext context) {
        AccessDeniedException.denyExecuteQuery();
    }

    default public void checkCanViewQueryOwnedBy(SystemSecurityContext context, Identity queryOwner) {
        this.checkCanViewQueryOwnedBy(context, queryOwner.getUser());
    }

    @Deprecated
    default public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        AccessDeniedException.denyViewQuery();
    }

    default public Collection<Identity> filterViewQueryOwnedBy(SystemSecurityContext context, Collection<Identity> queryOwners) {
        Set<String> ownerUsers = queryOwners.stream().map(Identity::getUser).collect(Collectors.toSet());
        Set<String> allowedUsers = this.filterViewQueryOwnedBy(context, ownerUsers);
        return queryOwners.stream().filter(owner -> allowedUsers.contains(owner.getUser())).collect(Collectors.toList());
    }

    @Deprecated
    default public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        return Collections.emptySet();
    }

    default public void checkCanKillQueryOwnedBy(SystemSecurityContext context, Identity queryOwner) {
        this.checkCanKillQueryOwnedBy(context, queryOwner.getUser());
    }

    @Deprecated
    default public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        AccessDeniedException.denyKillQuery();
    }

    default public void checkCanReadSystemInformation(SystemSecurityContext context) {
        AccessDeniedException.denyReadSystemInformationAccess();
    }

    default public void checkCanWriteSystemInformation(SystemSecurityContext context) {
        AccessDeniedException.denyWriteSystemInformationAccess();
    }

    default public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty(propertyName);
    }

    default public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        AccessDeniedException.denyCatalogAccess(catalogName);
    }

    default public void checkCanCreateCatalog(SystemSecurityContext context, String catalog) {
        AccessDeniedException.denyCreateCatalog(catalog);
    }

    default public void checkCanDropCatalog(SystemSecurityContext context, String catalog) {
        AccessDeniedException.denyDropCatalog(catalog);
    }

    default public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return Collections.emptySet();
    }

    default public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema, Map<String, Object> properties) {
        AccessDeniedException.denyCreateSchema(schema.toString());
    }

    default public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyDropSchema(schema.toString());
    }

    default public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schema.toString(), newSchemaName);
    }

    default public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        AccessDeniedException.denySetSchemaAuthorization(schema.toString(), principal);
    }

    default public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        AccessDeniedException.denyShowCreateSchema(schemaName.toString());
    }

    default public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowCreateTable(table.toString());
    }

    default public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        AccessDeniedException.denyCreateTable(table.toString());
    }

    default public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropTable(table.toString());
    }

    default public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        AccessDeniedException.denyRenameTable(table.toString(), newTable.toString());
    }

    default public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetTableProperties(table.toString());
    }

    default public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyCommentTable(table.toString());
    }

    default public void checkCanSetViewComment(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyCommentView(view.toString());
    }

    default public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyCommentColumn(table.toString());
    }

    default public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTables(schema.toString());
    }

    default public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyShowColumns(table.toString());
    }

    default public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        return Collections.emptySet();
    }

    default public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyAddColumn(table.toString());
    }

    default public void checkCanAlterColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyAlterColumn(table.toString());
    }

    default public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropColumn(table.toString());
    }

    default public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        AccessDeniedException.denySetTableAuthorization(table.toString(), principal);
    }

    default public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyRenameColumn(table.toString());
    }

    default public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denySelectColumns(table.toString(), columns);
    }

    default public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyInsertTable(table.toString());
    }

    default public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDeleteTable(table.toString());
    }

    default public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyTruncateTable(table.toString());
    }

    default public void checkCanUpdateTableColumns(SystemSecurityContext securityContext, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        AccessDeniedException.denyUpdateTableColumns(table.toString(), updatedColumnNames);
    }

    default public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateView(view.toString());
    }

    default public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        AccessDeniedException.denyRenameTable(view.toString(), newView.toString());
    }

    default public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        AccessDeniedException.denySetViewAuthorization(view.toString(), principal);
    }

    default public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyDropView(view.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denyCreateViewWithSelect(table.toString(), context.getIdentity());
    }

    default public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        AccessDeniedException.denyCreateMaterializedView(materializedView.toString());
    }

    default public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        AccessDeniedException.denyRefreshMaterializedView(materializedView.toString());
    }

    default public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetMaterializedViewProperties(materializedView.toString());
    }

    default public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        AccessDeniedException.denyDropMaterializedView(materializedView.toString());
    }

    default public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        AccessDeniedException.denyRenameMaterializedView(view.toString(), newView.toString());
    }

    default public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
        String granteeAsString = String.format("%s '%s'", grantee.getType().name().toLowerCase(Locale.ENGLISH), grantee.getName());
        AccessDeniedException.denyGrantExecuteFunctionPrivilege(functionName, context.getIdentity(), granteeAsString);
    }

    default public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, FunctionKind functionKind, CatalogSchemaRoutineName functionName, TrinoPrincipal grantee, boolean grantOption) {
        String granteeAsString = String.format("%s '%s'", grantee.getType().name().toLowerCase(Locale.ENGLISH), grantee.getName());
        AccessDeniedException.denyGrantExecuteFunctionPrivilege(functionName.toString(), context.getIdentity(), granteeAsString);
    }

    default public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantSchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenySchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeSchemaPrivilege(privilege.toString(), schema.toString());
    }

    default public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanShowRoles(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoles();
    }

    default public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole(role);
    }

    default public void checkCanDropRole(SystemSecurityContext context, String role) {
        AccessDeniedException.denyDropRole(role);
    }

    default public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    default public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    default public void checkCanShowRoleAuthorizationDescriptors(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoleAuthorizationDescriptors();
    }

    default public void checkCanShowCurrentRoles(SystemSecurityContext context) {
        AccessDeniedException.denyShowCurrentRoles();
    }

    default public void checkCanShowRoleGrants(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoleGrants();
    }

    default public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        AccessDeniedException.denyExecuteProcedure(procedure.toString());
    }

    default public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        AccessDeniedException.denyExecuteFunction(functionName);
    }

    default public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, FunctionKind functionKind, CatalogSchemaRoutineName functionName) {
        AccessDeniedException.denyExecuteFunction(functionName.toString());
    }

    default public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName table, String procedure) {
        AccessDeniedException.denyExecuteTableProcedure(table.toString(), procedure);
    }

    default public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return List.of();
    }

    default public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        List<ViewExpression> masks = this.getColumnMasks(context, tableName, columnName, type);
        if (masks.size() > 1) {
            throw new UnsupportedOperationException("Multiple masks on a single column are no longer supported");
        }
        return masks.stream().findFirst();
    }

    @Deprecated
    default public List<ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return List.of();
    }

    default public Iterable<EventListener> getEventListeners() {
        return Collections.emptySet();
    }
}

