/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import java.util.Objects;
import java.util.Optional;

@Experimental(eta="2022-10-31")
public class QualifiedFunctionName {
    private final Optional<String> catalogName;
    private final Optional<String> schemaName;
    private final String functionName;

    public static QualifiedFunctionName of(String functionName) {
        return new QualifiedFunctionName(Optional.empty(), Optional.empty(), functionName);
    }

    public static QualifiedFunctionName of(String schemaName, String functionName) {
        return new QualifiedFunctionName(Optional.empty(), Optional.of(schemaName), functionName);
    }

    public static QualifiedFunctionName of(String catalogName, String schemaName, String functionName) {
        return new QualifiedFunctionName(Optional.of(catalogName), Optional.of(schemaName), functionName);
    }

    private QualifiedFunctionName(Optional<String> catalogName, Optional<String> schemaName, String functionName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.map(String::isEmpty).orElse(false).booleanValue()) {
            throw new IllegalArgumentException("catalogName is empty");
        }
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        if (schemaName.map(String::isEmpty).orElse(false).booleanValue()) {
            throw new IllegalArgumentException("schemaName is empty");
        }
        if (catalogName.isPresent() && schemaName.isEmpty()) {
            throw new IllegalArgumentException("Schema name must be provided when catalog name is provided");
        }
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        if (functionName.isEmpty()) {
            throw new IllegalArgumentException("functionName is empty");
        }
    }

    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedFunctionName that = (QualifiedFunctionName)o;
        return this.catalogName.equals(that.catalogName) && this.schemaName.equals(that.schemaName) && this.functionName.equals(that.functionName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.functionName);
    }

    public String toString() {
        return this.catalogName.map(name -> name + ".").orElse("") + this.schemaName.map(name -> name + ".").orElse("") + this.functionName;
    }
}

