/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.QualifiedFunctionName;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public class FunctionDependencyDeclaration {
    public static final FunctionDependencyDeclaration NO_DEPENDENCIES = FunctionDependencyDeclaration.builder().build();
    private final Set<TypeSignature> typeDependencies;
    private final Set<FunctionDependency> functionDependencies;
    private final Set<OperatorDependency> operatorDependencies;
    private final Set<CastDependency> castDependencies;

    public static FunctionDependencyDeclarationBuilder builder() {
        return new FunctionDependencyDeclarationBuilder();
    }

    private FunctionDependencyDeclaration(Set<TypeSignature> typeDependencies, Set<FunctionDependency> functionDependencies, Set<OperatorDependency> operatorDependencies, Set<CastDependency> castDependencies) {
        this.typeDependencies = Set.copyOf((Collection)Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = Set.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        this.operatorDependencies = Set.copyOf((Collection)Objects.requireNonNull(operatorDependencies, "operatorDependencies is null"));
        this.castDependencies = Set.copyOf((Collection)Objects.requireNonNull(castDependencies, "castDependencies is null"));
    }

    public Set<TypeSignature> getTypeDependencies() {
        return this.typeDependencies;
    }

    public Set<FunctionDependency> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public Set<OperatorDependency> getOperatorDependencies() {
        return this.operatorDependencies;
    }

    public Set<CastDependency> getCastDependencies() {
        return this.castDependencies;
    }

    public static final class FunctionDependencyDeclarationBuilder {
        private final Set<TypeSignature> typeDependencies = new LinkedHashSet<TypeSignature>();
        private final Set<FunctionDependency> functionDependencies = new LinkedHashSet<FunctionDependency>();
        private final Set<OperatorDependency> operatorDependencies = new LinkedHashSet<OperatorDependency>();
        private final Set<CastDependency> castDependencies = new LinkedHashSet<CastDependency>();

        private FunctionDependencyDeclarationBuilder() {
        }

        public FunctionDependencyDeclarationBuilder addType(TypeSignature typeSignature) {
            this.typeDependencies.add(typeSignature);
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunction(QualifiedFunctionName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes.stream().map(Type::getTypeSignature).collect(Collectors.toUnmodifiableList()), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunctionSignature(QualifiedFunctionName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunction(QualifiedFunctionName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes.stream().map(Type::getTypeSignature).collect(Collectors.toUnmodifiableList()), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunctionSignature(QualifiedFunctionName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes.stream().map(Type::getTypeSignature).collect(Collectors.toUnmodifiableList()), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes.stream().map(Type::getTypeSignature).collect(Collectors.toUnmodifiableList()), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, true));
            return this;
        }

        public FunctionDependencyDeclaration build() {
            return new FunctionDependencyDeclaration(this.typeDependencies, this.functionDependencies, this.operatorDependencies, this.castDependencies);
        }
    }

    public static final class CastDependency {
        private final TypeSignature fromType;
        private final TypeSignature toType;
        private final boolean optional;

        private CastDependency(TypeSignature fromType, TypeSignature toType, boolean optional) {
            this.fromType = fromType;
            this.toType = toType;
            this.optional = optional;
        }

        public TypeSignature getFromType() {
            return this.fromType;
        }

        public TypeSignature getToType() {
            return this.toType;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CastDependency that = (CastDependency)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }

        public String toString() {
            return String.format("cast(%s, %s)", this.fromType, this.toType);
        }
    }

    public static final class OperatorDependency {
        private final OperatorType operatorType;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private OperatorDependency(OperatorType operatorType, List<TypeSignature> argumentTypes, boolean optional) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorDependency that = (OperatorDependency)o;
            return this.operatorType == that.operatorType && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operatorType, this.argumentTypes});
        }

        public String toString() {
            return this.operatorType + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class FunctionDependency {
        private final QualifiedFunctionName name;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private FunctionDependency(QualifiedFunctionName name, List<TypeSignature> argumentTypes, boolean optional) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        public QualifiedFunctionName getName() {
            return this.name;
        }

        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionDependency that = (FunctionDependency)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return this.name + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

