/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Unstable;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.ResourceEstimates;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class QueryContext {
    private final String user;
    private final Optional<String> principal;
    private final Set<String> groups;
    private final Optional<String> traceToken;
    private final Optional<String> remoteClientAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final Map<String, String> sessionProperties;
    private final ResourceEstimates resourceEstimates;
    private final String serverAddress;
    private final String serverVersion;
    private final String environment;
    private final Optional<QueryType> queryType;
    private final String retryPolicy;

    @JsonCreator
    @Unstable
    public QueryContext(String user, Optional<String> principal, Set<String> groups, Optional<String> traceToken, Optional<String> remoteClientAddress, Optional<String> userAgent, Optional<String> clientInfo, Set<String> clientTags, Set<String> clientCapabilities, Optional<String> source, Optional<String> catalog, Optional<String> schema, Optional<ResourceGroupId> resourceGroupId, Map<String, String> sessionProperties, ResourceEstimates resourceEstimates, String serverAddress, String serverVersion, String environment, Optional<QueryType> queryType, String retryPolicy) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.groups = Objects.requireNonNull(groups, "groups is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.remoteClientAddress = Objects.requireNonNull(remoteClientAddress, "remoteClientAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.clientCapabilities = Objects.requireNonNull(clientCapabilities, "clientCapabilities is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.serverAddress = Objects.requireNonNull(serverAddress, "serverAddress is null");
        this.serverVersion = Objects.requireNonNull(serverVersion, "serverVersion is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public Set<String> getGroups() {
        return this.groups;
    }

    @JsonProperty
    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    @JsonProperty
    public Optional<String> getRemoteClientAddress() {
        return this.remoteClientAddress;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    @JsonProperty
    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    @JsonProperty
    public String getServerAddress() {
        return this.serverAddress;
    }

    @JsonProperty
    public String getServerVersion() {
        return this.serverVersion;
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public String getRetryPolicy() {
        return this.retryPolicy;
    }
}

