/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.AbstractMapBlock;
import io.trino.spi.block.AbstractSingleMapBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class SingleMapBlock
extends AbstractSingleMapBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleMapBlock.class);
    private final int offset;
    private final int positionCount;
    private final AbstractMapBlock mapBlock;

    SingleMapBlock(int offset, int positionCount, AbstractMapBlock mapBlock) {
        this.offset = offset;
        this.positionCount = positionCount;
        this.mapBlock = mapBlock;
    }

    public Type getMapType() {
        return this.mapBlock.getMapType();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        return this.mapBlock.getRawKeyBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + this.mapBlock.getRawValueBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + SizeOf.sizeOfIntArray((int)(this.positionCount / 2 * 2));
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.mapBlock.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.mapBlock.getRawKeyBlock(), this.mapBlock.getRawKeyBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getRawValueBlock(), this.mapBlock.getRawValueBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getHashTables(), this.mapBlock.getHashTables().getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "MAP_ELEMENT";
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.mapBlock.getRawKeyBlock();
    }

    @Override
    Block getRawValueBlock() {
        return this.mapBlock.getRawValueBlock();
    }

    @Override
    public Block copyWithAppendedNull() {
        throw new UnsupportedOperationException("SingleMapBlock does not support newBlockWithAppendedNull()");
    }

    public String toString() {
        return String.format("SingleMapBlock{positionCount=%d}", this.getPositionCount());
    }

    @Override
    public boolean isLoaded() {
        return this.mapBlock.getRawKeyBlock().isLoaded() && this.mapBlock.getRawValueBlock().isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        if (this.mapBlock.getRawKeyBlock() != this.mapBlock.getRawKeyBlock().getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.mapBlock.getRawValueBlock().getLoadedBlock();
        if (loadedValueBlock == this.mapBlock.getRawValueBlock()) {
            return this;
        }
        return new SingleMapBlock(this.offset, this.positionCount, this.mapBlock);
    }

    public Optional<int[]> tryGetHashTable() {
        return this.mapBlock.getHashTables().tryGet();
    }

    public int seekKey(Object nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        if (nativeValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.getMapType().getKeyNativeHashCode().invoke(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapBlock.getMapType().getKeyBlockNativeEqual().invoke(this.mapBlock.getRawKeyBlock(), rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKey(MethodHandle keyEqualOperator, MethodHandle keyHashOperator, Block targetKeyBlock, int targetKeyPosition) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        SingleMapBlock.checkKeyNotNull(targetKeyBlock, targetKeyPosition);
        try {
            hashCode = keyHashOperator.invoke(targetKeyBlock, targetKeyPosition);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = keyEqualOperator.invoke(rawKeyBlock, rawKeyPosition, targetKeyBlock, targetKeyPosition);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(long nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.getMapType().getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapBlock.getMapType().getKeyBlockNativeEqual().invokeExact(rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(boolean nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.getMapType().getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapBlock.getMapType().getKeyBlockNativeEqual().invokeExact(rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(double nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.getMapType().getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapBlock.getMapType().getKeyBlockNativeEqual().invokeExact(rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Object nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        if (nativeValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.getMapType().getKeyNativeHashCode().invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapHashTables.computePosition(hashCode, hashTableSize);
        Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            int rawKeyPosition = this.offset / 2 + keyPosition;
            SingleMapBlock.checkKeyNotNull(rawKeyBlock, rawKeyPosition);
            try {
                match = this.mapBlock.getMapType().getKeyBlockNativeEqual().invokeExact(rawKeyBlock, rawKeyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    private static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof TrinoException) {
            throw (TrinoException)throwable;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
    }

    private static void checkKeyNotNull(Block keyBlock, int positionCount) {
        if (keyBlock.isNull(positionCount)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
    }

    private static void checkNotIndeterminate(Boolean equalResult) {
        if (equalResult == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
    }
}

