/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.AbstractMapBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.type.MapType;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;

public class MapBlock
extends AbstractMapBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapBlock.class);
    private final int startOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private final MapHashTables hashTables;
    private final long baseSizeInBytes;
    private volatile long valueSizeInBytes = -1L;
    private final long retainedSizeInBytes;

    public static MapBlock fromKeyValueBlock(Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapType mapType) {
        return MapBlock.fromKeyValueBlock(mapIsNull, offsets, offsets.length - 1, keyBlock, valueBlock, mapType);
    }

    public static MapBlock fromKeyValueBlock(Optional<boolean[]> mapIsNull, int[] offsets, int mapCount, Block keyBlock, Block valueBlock, MapType mapType) {
        MapBlock.validateConstructorArguments(mapType, 0, mapCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock);
        return MapBlock.createMapBlockInternal(mapType, 0, mapCount, mapIsNull, offsets, keyBlock, valueBlock, new MapHashTables(mapType, Optional.empty()));
    }

    public static MapBlock createMapBlockInternal(MapType mapType, int startOffset, int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapHashTables hashTables) {
        MapBlock.validateConstructorArguments(mapType, startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock);
        Objects.requireNonNull(hashTables, "hashTables is null");
        return new MapBlock(mapType, startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, hashTables);
    }

    private static void validateConstructorArguments(MapType mapType, int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (mapIsNull != null && mapIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(keyBlock, "keyBlock is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        Objects.requireNonNull(mapType, "mapType is null");
    }

    private MapBlock(MapType mapType, int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapHashTables hashTables) {
        super(mapType);
        int[] rawHashTables = hashTables.tryGet().orElse(null);
        if (rawHashTables != null && rawHashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), rawHashTables.length));
        }
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = offsets;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
        this.hashTables = hashTables;
        int entryCount = offsets[startOffset + positionCount] - offsets[startOffset];
        this.baseSizeInBytes = 8L * (long)entryCount + 5L * (long)this.positionCount + this.calculateSize(keyBlock);
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])mapIsNull);
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlock;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlock;
    }

    @Override
    protected MapHashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public boolean mayHaveNull() {
        return this.mapIsNull != null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.valueSizeInBytes < 0L) {
            if (!this.valueBlock.isLoaded()) {
                return this.baseSizeInBytes + this.valueBlock.getSizeInBytes();
            }
            this.valueSizeInBytes = this.calculateSize(this.valueBlock);
        }
        return this.baseSizeInBytes + this.valueSizeInBytes;
    }

    private long calculateSize(Block block) {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        return block.getRegionSizeInBytes(entriesStart, entryCount);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.keyBlock.getRetainedSizeInBytes() + this.valueBlock.getRetainedSizeInBytes() + this.hashTables.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        if (this.mapIsNull != null) {
            consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        }
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isLoaded() {
        return this.keyBlock.isLoaded() && this.valueBlock.isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        if (this.keyBlock != this.keyBlock.getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.valueBlock.getLoadedBlock();
        if (loadedValueBlock == this.valueBlock) {
            return this;
        }
        return MapBlock.createMapBlockInternal(this.getMapType(), this.startOffset, this.positionCount, Optional.ofNullable(this.mapIsNull), this.offsets, this.keyBlock, loadedValueBlock, this.hashTables);
    }

    @Override
    protected void ensureHashTableLoaded() {
        this.hashTables.buildAllHashTablesIfNecessary(this.getRawKeyBlock(), this.offsets, this.mapIsNull);
    }

    @Override
    public Block copyWithAppendedNull() {
        boolean[] newMapIsNull = BlockUtil.copyIsNullAndAppendNull(this.getMapIsNull(), this.getOffsetBase(), this.getPositionCount());
        int[] newOffsets = BlockUtil.copyOffsetsAndAppendNull(this.getOffsets(), this.getOffsetBase(), this.getPositionCount());
        return MapBlock.createMapBlockInternal(this.getMapType(), this.getOffsetBase(), this.getPositionCount() + 1, Optional.of(newMapIsNull), newOffsets, this.getRawKeyBlock(), this.getRawValueBlock(), this.getHashTables());
    }
}

