/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.DictionaryBlock;
import java.util.Optional;

public class DictionaryBlockEncoding
implements BlockEncoding {
    public static final String NAME = "DICTIONARY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
        if (!dictionaryBlock.isCompact()) {
            throw new IllegalArgumentException("Dictionary should be compact");
        }
        int positionCount = dictionaryBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        Block dictionary = dictionaryBlock.getDictionary();
        blockEncodingSerde.writeBlock(sliceOutput, dictionary);
        sliceOutput.writeBytes(dictionaryBlock.getIds());
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block dictionaryBlock = blockEncodingSerde.readBlock(sliceInput);
        int[] ids = new int[positionCount];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])ids));
        return dictionaryBlock.copyPositions(ids, 0, ids.length);
    }

    @Override
    public Optional<Block> replacementBlockForWrite(Block block) {
        DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
        if (!dictionaryBlock.isCompact()) {
            return Optional.of(dictionaryBlock.compact());
        }
        if (dictionaryBlock.getUniqueIds() == dictionaryBlock.getPositionCount() && dictionaryBlock.isSequentialIds()) {
            return Optional.of(dictionaryBlock.getDictionary());
        }
        return Optional.empty();
    }
}

