/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.VariableWidthBlock;

public abstract class AbstractVariableWidthBlock
implements Block {
    protected abstract Slice getRawSlice(int var1);

    protected abstract int getPositionOffset(int var1);

    protected abstract boolean isEntryNull(int var1);

    @Override
    public String getEncodingName() {
        return "VARIABLE_WIDTH";
    }

    @Override
    public byte getByte(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).getByte(this.getPositionOffset(position) + offset);
    }

    @Override
    public short getShort(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).getShort(this.getPositionOffset(position) + offset);
    }

    @Override
    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).getInt(this.getPositionOffset(position) + offset);
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).getLong(this.getPositionOffset(position) + offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).slice(this.getPositionOffset(position) + offset, length);
    }

    @Override
    public void writeSliceTo(int position, int offset, int length, SliceOutput output) {
        BlockUtil.checkReadablePosition(this, position);
        output.writeBytes(this.getRawSlice(position), this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getSliceLength(position) < length) {
            return false;
        }
        return otherBlock.bytesEqual(otherPosition, otherOffset, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).equals(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return XxHash64.hash((Slice)this.getRawSlice(position), (int)(this.getPositionOffset(position) + offset), (int)length);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        BlockUtil.checkReadablePosition(this, position);
        Slice rawSlice = this.getRawSlice(position);
        if (this.getSliceLength(position) < length) {
            throw new IllegalArgumentException("Length longer than value length");
        }
        return -otherBlock.bytesCompare(otherPosition, otherOffset, otherLength, rawSlice, this.getPositionOffset(position) + offset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getRawSlice(position).compareTo(this.getPositionOffset(position) + offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getSliceLength(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(position), (int)offset, (int)entrySize);
        return new VariableWidthBlock(0, 1, copy, new int[]{0, copy.length()}, null);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : (long)this.getSliceLength(position);
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.isEntryNull(position);
    }
}

