/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.IntArrayList;
import io.trino.spi.block.RunLengthEncodedBlock;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;

public abstract class AbstractArrayBlock
implements Block {
    @Override
    public final List<Block> getChildren() {
        return Collections.singletonList(this.getRawElementBlock());
    }

    protected abstract Block getRawElementBlock();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getValueIsNull();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "ARRAY";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        newOffsets[0] = 0;
        boolean[] newValueIsNull = this.getValueIsNull() == null ? null : new boolean[length];
        IntArrayList valuesPositions = new IntArrayList();
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (newValueIsNull != null && this.isNull(position)) {
                newValueIsNull[i] = true;
                newOffsets[i + 1] = newOffsets[i];
                continue;
            }
            int valuesStartOffset = this.getOffset(position);
            int valuesEndOffset = this.getOffset(position + 1);
            int valuesLength = valuesEndOffset - valuesStartOffset;
            newOffsets[i + 1] = newOffsets[i] + valuesLength;
            for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                valuesPositions.add(elementIndex);
            }
        }
        Block newValues = this.getRawElementBlock().copyPositions(valuesPositions.elements(), 0, valuesPositions.size());
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return ArrayBlock.createArrayBlockInternal(position + this.getOffsetBase(), length, this.getValueIsNull(), this.getOffsets(), this.getRawElementBlock());
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getRawElementBlock().getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public final long getPositionsSizeInBytes(boolean[] positions, int selectedArrayPositions) {
        long elementsSizeInBytes;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        if (selectedArrayPositions == 0) {
            return 0L;
        }
        if (selectedArrayPositions == positionCount) {
            return this.getSizeInBytes();
        }
        Block rawElementBlock = this.getRawElementBlock();
        OptionalInt fixedPerElementSizeInBytes = rawElementBlock.fixedSizeInBytesPerPosition();
        int[] offsets = this.getOffsets();
        int offsetBase = this.getOffsetBase();
        if (fixedPerElementSizeInBytes.isPresent()) {
            elementsSizeInBytes = (long)fixedPerElementSizeInBytes.getAsInt() * (long)BlockUtil.countSelectedPositionsFromOffsets(positions, offsets, offsetBase);
        } else if (rawElementBlock instanceof RunLengthEncodedBlock) {
            elementsSizeInBytes = rawElementBlock.getPositionsSizeInBytes(null, BlockUtil.countSelectedPositionsFromOffsets(positions, offsets, offsetBase));
        } else {
            boolean[] selectedElements = new boolean[rawElementBlock.getPositionCount()];
            int selectedElementCount = BlockUtil.countAndMarkSelectedPositionsFromOffsets(positions, offsets, offsetBase, selectedElements);
            elementsSizeInBytes = rawElementBlock.getPositionsSizeInBytes(selectedElements, selectedElementCount);
        }
        return elementsSizeInBytes + 5L * (long)selectedArrayPositions;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newValueIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] valueIsNull = this.getValueIsNull();
        boolean[] blArray = newValueIsNull = valueIsNull == null ? null : BlockUtil.compactArray(valueIsNull, position + this.getOffsetBase(), length);
        if (newValues == this.getRawElementBlock() && newOffsets == this.getOffsets() && newValueIsNull == valueIsNull) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return clazz.cast(this.getRawElementBlock().getRegion(startValueOffset, endValueOffset - startValueOffset));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.getOffset(position);
        int valueLength = this.getOffset(position + 1) - startValueOffset;
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, valueLength);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return ArrayBlock.createArrayBlockInternal(0, 1, blArray, new int[]{0, valueLength}, newValues);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        Block rawElementBlock = this.getRawElementBlock();
        long size = 0L;
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawElementBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        boolean[] valueIsNull = this.getValueIsNull();
        return valueIsNull != null && valueIsNull[position + this.getOffsetBase()];
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return function.apply(this.getRawElementBlock(), startValueOffset, endValueOffset - startValueOffset);
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

