/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import io.trino.orc.metadata.statistics.BloomFilterBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.IntegerStatistics;
import io.trino.orc.metadata.statistics.LongValueStatisticsBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class TimeMicrosStatisticsBuilder
implements LongValueStatisticsBuilder {
    private long nonNullValueCount;
    private long minimum = Long.MAX_VALUE;
    private long maximum = Long.MIN_VALUE;
    private long sum;
    private boolean overflow;
    private final BloomFilterBuilder bloomFilterBuilder;

    public TimeMicrosStatisticsBuilder(BloomFilterBuilder bloomFilterBuilder) {
        this.bloomFilterBuilder = Objects.requireNonNull(bloomFilterBuilder, "bloomFilterBuilder is null");
    }

    @Override
    public long getValueFromBlock(Type type, Block block, int position) {
        return type.getLong(block, position) / 1000000L;
    }

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        this.minimum = Math.min(value, this.minimum);
        this.maximum = Math.max(value, this.maximum);
        if (!this.overflow) {
            try {
                this.sum = Math.addExact(this.sum, value);
            }
            catch (ArithmeticException e) {
                this.overflow = true;
            }
        }
        this.bloomFilterBuilder.addLong(value);
    }

    private Optional<IntegerStatistics> buildIntegerStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new IntegerStatistics(this.minimum, this.maximum, this.overflow ? null : Long.valueOf(this.sum)));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<IntegerStatistics> integerStatistics = this.buildIntegerStatistics();
        return new ColumnStatistics(this.nonNullValueCount, integerStatistics.map(s -> 9L).orElse(0L), null, integerStatistics.orElse(null), null, null, null, null, null, null, null, this.bloomFilterBuilder.buildBloomFilter());
    }
}

