/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.iceberg.procedure.IcebergProcedureHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableProcedureId;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class IcebergTableExecuteHandle
implements ConnectorTableExecuteHandle {
    private final SchemaTableName schemaTableName;
    private final IcebergTableProcedureId procedureId;
    private final IcebergProcedureHandle procedureHandle;
    private final String tableLocation;

    @JsonCreator
    public IcebergTableExecuteHandle(SchemaTableName schemaTableName, IcebergTableProcedureId procedureId, IcebergProcedureHandle procedureHandle, String tableLocation) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.procedureId = Objects.requireNonNull(procedureId, "procedureId is null");
        this.procedureHandle = Objects.requireNonNull(procedureHandle, "procedureHandle is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public IcebergTableProcedureId getProcedureId() {
        return this.procedureId;
    }

    @JsonProperty
    public IcebergProcedureHandle getProcedureHandle() {
        return this.procedureHandle;
    }

    @JsonProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    public IcebergTableExecuteHandle withProcedureHandle(IcebergProcedureHandle procedureHandle) {
        return new IcebergTableExecuteHandle(this.schemaTableName, this.procedureId, procedureHandle, this.tableLocation);
    }

    public String toString() {
        return "schemaTableName" + ":" + this.schemaTableName + ", procedureId" + ":" + (Object)((Object)this.procedureId) + ", procedureHandle" + ":{" + this.procedureHandle + "}";
    }
}

