/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.fileio;

import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.iceberg.fileio.ForwardingSeekableInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;

public class ForwardingInputFile
implements InputFile {
    private final TrinoInputFile inputFile;

    public ForwardingInputFile(TrinoInputFile inputFile) {
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
    }

    public long getLength() {
        try {
            return this.inputFile.length();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get status for file: " + this.location(), e);
        }
    }

    public SeekableInputStream newStream() {
        try {
            return new ForwardingSeekableInputStream(this.inputFile.newStream());
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException((Throwable)e, "Failed to open input stream for file: %s", new Object[]{this.location()});
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open input stream for file: " + this.location(), e);
        }
    }

    public String location() {
        return this.inputFile.location().toString();
    }

    public boolean exists() {
        try {
            return this.inputFile.exists();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to check existence for file: " + this.location(), e);
        }
    }

    public String toString() {
        return this.inputFile.toString();
    }
}

