/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.fileio;

import com.google.common.collect.Iterables;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.plugin.iceberg.fileio.ForwardingOutputFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;

public class ForwardingFileIo
implements SupportsBulkOperations {
    private static final int DELETE_BATCH_SIZE = 1000;
    private static final int BATCH_DELETE_PATHS_MESSAGE_LIMIT = 5;
    private final TrinoFileSystem fileSystem;

    public ForwardingFileIo(TrinoFileSystem fileSystem) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
    }

    public InputFile newInputFile(String path) {
        return new ForwardingInputFile(this.fileSystem.newInputFile(Location.of((String)path)));
    }

    public InputFile newInputFile(String path, long length) {
        return new ForwardingInputFile(this.fileSystem.newInputFile(Location.of((String)path), length));
    }

    public OutputFile newOutputFile(String path) {
        return new ForwardingOutputFile(this.fileSystem, path);
    }

    public void deleteFile(String path) {
        try {
            this.fileSystem.deleteFile(Location.of((String)path));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + path, e);
        }
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        Iterable partitions = Iterables.partition(pathsToDelete, (int)1000);
        partitions.forEach(this::deleteBatch);
    }

    private void deleteBatch(List<String> filesToDelete) {
        try {
            this.fileSystem.deleteFiles(filesToDelete.stream().map(Location::of).toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete some or all of files: " + Stream.concat(filesToDelete.stream().limit(5L), filesToDelete.size() > 5 ? Stream.of("...") : Stream.of(new String[0])).collect(Collectors.joining(", ", "[", "]")), e);
        }
    }
}

