/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.base.Preconditions;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.MetricsWrapper;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.LocationProvider;

public class IcebergPositionDeletePageSink
implements ConnectorPageSink {
    private final String dataFilePath;
    private final PartitionSpec partitionSpec;
    private final Optional<PartitionData> partition;
    private final String outputPath;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriter writer;
    private final IcebergFileFormat fileFormat;
    private long validationCpuNanos;
    private boolean writtenData;

    public IcebergPositionDeletePageSink(String dataFilePath, PartitionSpec partitionSpec, Optional<PartitionData> partition, LocationProvider locationProvider, IcebergFileWriterFactory fileWriterFactory, TrinoFileSystem fileSystem, JsonCodec<CommitTaskData> jsonCodec, ConnectorSession session, IcebergFileFormat fileFormat, Map<String, String> storageProperties) {
        this.dataFilePath = Objects.requireNonNull(dataFilePath, "dataFilePath is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.partitionSpec = Objects.requireNonNull(partitionSpec, "partitionSpec is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        String fileName = fileFormat.toIceberg().addExtension(session.getQueryId() + "-" + UUID.randomUUID());
        this.outputPath = partition.map(partitionData -> locationProvider.newDataLocation(partitionSpec, (StructLike)partitionData, fileName)).orElseGet(() -> locationProvider.newDataLocation(fileName));
        this.writer = fileWriterFactory.createPositionDeleteWriter(fileSystem, Location.of((String)this.outputPath), session, fileFormat, storageProperties);
    }

    public long getCompletedBytes() {
        return this.writer.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.writer.getMemoryUsage();
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<?> appendPage(Page page) {
        Preconditions.checkArgument((page.getChannelCount() == 1 ? 1 : 0) != 0, (Object)("IcebergPositionDeletePageSink expected a Page with only one channel, but got " + page.getChannelCount()));
        Block[] blocks = new Block[]{RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)this.dataFilePath)), (int)page.getPositionCount()), page.getBlock(0)};
        this.writer.appendRows(new Page(blocks));
        this.writtenData = true;
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList<Slice> commitTasks = new ArrayList<Slice>();
        if (this.writtenData) {
            this.writer.commit();
            CommitTaskData task = new CommitTaskData(this.outputPath, this.fileFormat, this.writer.getWrittenBytes(), new MetricsWrapper(this.writer.getMetrics()), PartitionSpecParser.toJson((PartitionSpec)this.partitionSpec), this.partition.map(PartitionData::toJson), FileContent.POSITION_DELETES, Optional.of(this.dataFilePath));
            Long recordCount = task.getMetrics().recordCount();
            if (recordCount != null && recordCount > 0L) {
                commitTasks.add(Slices.wrappedBuffer((byte[])this.jsonCodec.toJsonBytes((Object)task)));
            }
            this.validationCpuNanos = this.writer.getValidationCpuNanos();
        } else {
            this.writer.rollback();
        }
        return CompletableFuture.completedFuture(commitTasks);
    }

    public void abort() {
        this.writer.rollback();
    }
}

