/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.base.io.ByteBuffers;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;

public final class DeleteFile {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(DeleteFile.class);
    private final FileContent content;
    private final String path;
    private final FileFormat format;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final List<Integer> equalityFieldIds;
    private final Map<Integer, byte[]> lowerBounds;
    private final Map<Integer, byte[]> upperBounds;

    public static DeleteFile fromIceberg(org.apache.iceberg.DeleteFile deleteFile) {
        Map lowerBounds = (Map)((Map)MoreObjects.firstNonNull((Object)deleteFile.lowerBounds(), (Object)ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (byte[])ByteBuffers.getWrappedBytes((ByteBuffer)((ByteBuffer)entry.getValue())).clone()));
        Map upperBounds = (Map)((Map)MoreObjects.firstNonNull((Object)deleteFile.upperBounds(), (Object)ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (byte[])ByteBuffers.getWrappedBytes((ByteBuffer)((ByteBuffer)entry.getValue())).clone()));
        return new DeleteFile(deleteFile.content(), deleteFile.path().toString(), deleteFile.format(), deleteFile.recordCount(), deleteFile.fileSizeInBytes(), Optional.ofNullable(deleteFile.equalityFieldIds()).orElseGet(ImmutableList::of), lowerBounds, upperBounds);
    }

    @JsonCreator
    public DeleteFile(FileContent content, String path, FileFormat format, long recordCount, long fileSizeInBytes, List<Integer> equalityFieldIds, Map<Integer, byte[]> lowerBounds, Map<Integer, byte[]> upperBounds) {
        this.content = Objects.requireNonNull(content, "content is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.equalityFieldIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null"));
        this.lowerBounds = ImmutableMap.copyOf(Objects.requireNonNull(lowerBounds, "lowerBounds is null"));
        this.upperBounds = ImmutableMap.copyOf(Objects.requireNonNull(upperBounds, "upperBounds is null"));
    }

    @JsonProperty
    public FileContent content() {
        return this.content;
    }

    @JsonProperty
    public String path() {
        return this.path;
    }

    @JsonProperty
    public FileFormat format() {
        return this.format;
    }

    @JsonProperty
    public long recordCount() {
        return this.recordCount;
    }

    @JsonProperty
    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    @JsonProperty
    public List<Integer> equalityFieldIds() {
        return this.equalityFieldIds;
    }

    @JsonProperty
    public Map<Integer, byte[]> getLowerBounds() {
        return this.lowerBounds;
    }

    @JsonProperty
    public Map<Integer, byte[]> getUpperBounds() {
        return this.upperBounds;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.equalityFieldIds, ignored -> 4L) + SizeOf.estimatedSizeOf(this.lowerBounds, entry -> 4L, SizeOf::sizeOf) + SizeOf.estimatedSizeOf(this.upperBounds, entry -> 4L, SizeOf::sizeOf);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("records", this.recordCount).toString();
    }
}

