/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.jsonwebtoken.impl.DefaultJwtBuilder;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.trino.filesystem.Locations;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.rest.RESTSessionCatalog;

public class TrinoRestCatalog
implements TrinoCatalog {
    private final RESTSessionCatalog restSessionCatalog;
    private final CatalogName catalogName;
    private final IcebergRestCatalogConfig.SessionType sessionType;
    private final String trinoVersion;
    private final boolean useUniqueTableLocation;
    private final Map<String, Table> tableCache = new ConcurrentHashMap<String, Table>();

    public TrinoRestCatalog(RESTSessionCatalog restSessionCatalog, CatalogName catalogName, IcebergRestCatalogConfig.SessionType sessionType, String trinoVersion, boolean useUniqueTableLocation) {
        this.restSessionCatalog = Objects.requireNonNull(restSessionCatalog, "restSessionCatalog is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.sessionType = Objects.requireNonNull(sessionType, "sessionType is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        return this.restSessionCatalog.namespaceExists(this.convert(session), Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return (List)this.restSessionCatalog.listNamespaces(this.convert(session)).stream().map(Namespace::toString).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.restSessionCatalog.dropNamespace(this.convert(session), Namespace.of((String[])new String[]{namespace}));
        }
        catch (NoSuchNamespaceException e) {
            throw new SchemaNotFoundException(namespace);
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            return ImmutableMap.copyOf((Map)this.restSessionCatalog.loadNamespaceMetadata(this.convert(session), Namespace.of((String[])new String[]{namespace})));
        }
        catch (NoSuchNamespaceException e) {
            throw new SchemaNotFoundException(namespace);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        this.restSessionCatalog.createNamespace(this.convert(session), Namespace.of((String[])new String[]{namespace}), Maps.transformValues(properties, property -> {
            if (property instanceof String) {
                String stringProperty = (String)property;
                return stringProperty;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Non-string properties are not support for Iceberg REST catalog");
        }));
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg REST catalog");
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        SessionCatalog.SessionContext sessionContext = this.convert(session);
        List namespaces = namespace.isPresent() && this.namespaceExists(session, namespace.get()) ? ImmutableList.of((Object)Namespace.of((String[])new String[]{namespace.get()})) : (List)this.listNamespaces(session).stream().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder tables = ImmutableList.builder();
        for (Namespace restNamespace : namespaces) {
            try {
                tables.addAll((Iterable)this.restSessionCatalog.listTables(sessionContext, restNamespace).stream().map(id -> SchemaTableName.schemaTableName((String)id.namespace().toString(), (String)id.name())).collect(ImmutableList.toImmutableList()));
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {}
        }
        return tables.build();
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.restSessionCatalog.buildTable(this.convert(session), TrinoRestCatalog.toIdentifier(schemaTableName), schema).withPartitionSpec(partitionSpec).withSortOrder(sortOrder).withLocation(location).withProperties(properties).createTransaction();
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName tableName, TableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "registerTable is not supported for Iceberg REST catalog");
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName tableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unregisterTable is not supported for Iceberg REST catalogs");
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        if (!this.restSessionCatalog.purgeTable(this.convert(session), TrinoRestCatalog.toIdentifier(schemaTableName))) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to drop table: %s", schemaTableName));
        }
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop corrupted table %s from Iceberg REST catalog".formatted(schemaTableName));
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        try {
            this.restSessionCatalog.renameTable(this.convert(session), TrinoRestCatalog.toIdentifier(from), TrinoRestCatalog.toIdentifier(to));
        }
        catch (RESTException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to rename table %s to %s", from, to), (Throwable)e);
        }
    }

    @Override
    public Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        try {
            return this.tableCache.computeIfAbsent(schemaTableName.toString(), key -> {
                BaseTable baseTable = (BaseTable)this.restSessionCatalog.loadTable(this.convert(session), TrinoRestCatalog.toIdentifier(schemaTableName));
                return new BaseTable(baseTable.operations(), IcebergUtil.quotedTableName(schemaTableName));
            });
        }
        catch (NoSuchTableException e) {
            throw new TableNotFoundException(schemaTableName, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to load table: %s", schemaTableName), (Throwable)e);
        }
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        return ImmutableMap.of();
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        Table icebergTable = this.restSessionCatalog.loadTable(this.convert(session), TrinoRestCatalog.toIdentifier(schemaTableName));
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        String tableName = this.createLocationForTable(schemaTableName.getTableName());
        Map<String, Object> properties = this.loadNamespaceMetadata(session, schemaTableName.getSchemaName());
        String databaseLocation = (String)properties.get("location");
        Preconditions.checkArgument((databaseLocation != null ? 1 : 0) != 0, (String)"location must be set for %s", (Object)schemaTableName.getSchemaName());
        if (databaseLocation.endsWith("/")) {
            return databaseLocation + tableName;
        }
        return Locations.appendPath((String)databaseLocation, (String)tableName);
    }

    private String createLocationForTable(String baseTableName) {
        Object tableName = baseTableName;
        if (this.useUniqueTableLocation) {
            tableName = (String)tableName + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return tableName;
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createView is not supported for Iceberg REST catalog");
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameView is not supported for Iceberg REST catalog");
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg REST catalog");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropView is not supported for Iceberg REST catalog");
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableList.of();
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableMap.of();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.empty();
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableList.of();
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.empty();
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        this.loadTable(session, schemaTableName).updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        return Optional.empty();
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName schemaViewName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateViewComment is not supported for Iceberg REST catalog");
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateViewColumnComment is not supported for Iceberg REST catalog");
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateMaterializedViewColumnComment is not supported for Iceberg REST catalog");
    }

    private SessionCatalog.SessionContext convert(ConnectorSession session) {
        return switch (this.sessionType) {
            default -> throw new IncompatibleClassChangeError();
            case IcebergRestCatalogConfig.SessionType.NONE -> new SessionCatalog.SessionContext(UUID.randomUUID().toString(), null, null, (Map)ImmutableMap.of(), (Object)session.getIdentity());
            case IcebergRestCatalogConfig.SessionType.USER -> {
                String sessionId = String.format("%s-%s", session.getUser(), session.getSource().orElse("default"));
                ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)session.getUser(), (Object)"source", (Object)session.getSource().orElse(""), (Object)"trinoCatalog", (Object)this.catalogName.toString(), (Object)"trinoVersion", (Object)this.trinoVersion);
                ImmutableMap claims = ImmutableMap.builder().putAll((Map)properties).buildOrThrow();
                String subjectJwt = new DefaultJwtBuilder().setSubject(session.getUser()).setIssuer(this.trinoVersion).setIssuedAt(new Date()).addClaims((Map)claims).serializeToJsonWith((Serializer)new JacksonSerializer()).compact();
                ImmutableMap credentials = ImmutableMap.builder().putAll(session.getIdentity().getExtraCredentials()).put((Object)"urn:ietf:params:oauth:token-type:jwt", (Object)subjectJwt).buildOrThrow();
                yield new SessionCatalog.SessionContext(sessionId, session.getUser(), (Map)credentials, (Map)properties, (Object)session.getIdentity());
            }
        };
    }

    private static TableIdentifier toIdentifier(SchemaTableName schemaTableName) {
        return TableIdentifier.of((String[])new String[]{schemaTableName.getSchemaName(), schemaTableName.getTableName()});
    }
}

