/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.plugin.iceberg.catalog.rest.SecurityProperties;
import io.trino.plugin.iceberg.catalog.rest.TrinoRestCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTSessionCatalog;

public class TrinoIcebergRestCatalogFactory
implements TrinoCatalogFactory {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final CatalogName catalogName;
    private final String trinoVersion;
    private final URI serverUri;
    private final Optional<String> warehouse;
    private final IcebergRestCatalogConfig.SessionType sessionType;
    private final SecurityProperties securityProperties;
    private final boolean uniqueTableLocation;
    @GuardedBy(value="this")
    private RESTSessionCatalog icebergCatalog;

    @Inject
    public TrinoIcebergRestCatalogFactory(TrinoFileSystemFactory fileSystemFactory, CatalogName catalogName, IcebergRestCatalogConfig restConfig, SecurityProperties securityProperties, IcebergConfig icebergConfig, NodeVersion nodeVersion) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.trinoVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        Objects.requireNonNull(restConfig, "restConfig is null");
        this.serverUri = restConfig.getBaseUri();
        this.warehouse = restConfig.getWarehouse();
        this.sessionType = restConfig.getSessionType();
        this.securityProperties = Objects.requireNonNull(securityProperties, "securityProperties is null");
        Objects.requireNonNull(icebergConfig, "icebergConfig is null");
        this.uniqueTableLocation = icebergConfig.isUniqueTableLocation();
    }

    @Override
    public synchronized TrinoCatalog create(ConnectorIdentity identity) {
        if (this.icebergCatalog == null) {
            ImmutableMap.Builder properties = ImmutableMap.builder();
            properties.put((Object)"uri", (Object)this.serverUri.toString());
            this.warehouse.ifPresent(location -> properties.put((Object)"warehouse", location));
            properties.put((Object)"trino-version", (Object)this.trinoVersion);
            properties.putAll(this.securityProperties.get());
            RESTSessionCatalog icebergCatalogInstance = new RESTSessionCatalog(config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build(), (context, config) -> {
                ConnectorIdentity currentIdentity = context.wrappedIdentity() != null ? (ConnectorIdentity)context.wrappedIdentity() : ConnectorIdentity.ofUser((String)"fake");
                return new ForwardingFileIo(this.fileSystemFactory.create(currentIdentity));
            });
            icebergCatalogInstance.initialize(this.catalogName.toString(), (Map)properties.buildOrThrow());
            this.icebergCatalog = icebergCatalogInstance;
        }
        return new TrinoRestCatalog(this.icebergCatalog, this.catalogName, this.sessionType, this.trinoVersion, this.uniqueTableLocation);
    }
}

