/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.net.URI;

public class IcebergNessieCatalogConfig {
    private String defaultReferenceName = "main";
    private String defaultWarehouseDir;
    private URI serverUri;

    @NotNull
    public String getDefaultReferenceName() {
        return this.defaultReferenceName;
    }

    @Config(value="iceberg.nessie-catalog.ref")
    @ConfigDescription(value="The default Nessie reference to work on")
    public IcebergNessieCatalogConfig setDefaultReferenceName(String defaultReferenceName) {
        this.defaultReferenceName = defaultReferenceName;
        return this;
    }

    @NotNull
    public URI getServerUri() {
        return this.serverUri;
    }

    @Config(value="iceberg.nessie-catalog.uri")
    @ConfigDescription(value="The URI to connect to the Nessie server")
    public IcebergNessieCatalogConfig setServerUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    @NotEmpty
    public String getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="iceberg.nessie-catalog.default-warehouse-dir")
    @ConfigDescription(value="The default warehouse to use for Nessie")
    public IcebergNessieCatalogConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = defaultWarehouseDir;
        return this;
    }
}

