/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.InvalidInputException;
import com.amazonaws.services.glue.model.ResourceNumberLimitExceededException;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

public class GlueIcebergTableOperations
extends AbstractIcebergTableOperations {
    private final TypeManager typeManager;
    private final boolean cacheTableMetadata;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    private final GetGlueTable getGlueTable;
    @Nullable
    private String glueVersionId;

    protected GlueIcebergTableOperations(TypeManager typeManager, boolean cacheTableMetadata, AWSGlueAsync glueClient, GlueMetastoreStats stats, GetGlueTable getGlueTable, FileIO fileIo, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cacheTableMetadata = cacheTableMetadata;
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.getGlueTable = Objects.requireNonNull(getGlueTable, "getGlueTable is null");
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        Table table = this.getTable(invalidateCaches);
        this.glueVersionId = table.getVersionId();
        Map parameters = GlueToTrinoConverter.getTableParameters((Table)table);
        if (ViewReaderUtil.isPrestoView((Map)parameters) && ViewReaderUtil.isHiveOrPrestoView((String)GlueToTrinoConverter.getTableType((Table)table))) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!HiveUtil.isIcebergTable((Map)parameters)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)parameters.get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        return metadataLocation;
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        Verify.verify((boolean)this.version.isEmpty(), (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        String newMetadataLocation = this.writeNewMetadata(metadata, 0);
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, this.tableName, this.owner, metadata, newMetadataLocation, (Map<String, String>)ImmutableMap.of(), this.cacheTableMetadata);
        CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput);
        try {
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
        }
        catch (AlreadyExistsException | EntityNotFoundException | InvalidInputException | ResourceNumberLimitExceededException e) {
            this.fileIo.deleteFile(newMetadataLocation);
            throw e;
        }
        this.shouldRefresh = true;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, this.tableName, this.owner, metadata, newMetadataLocation, (Map<String, String>)ImmutableMap.of((Object)"previous_metadata_location", (Object)this.currentMetadataLocation), this.cacheTableMetadata);
        UpdateTableRequest updateTableRequest = new UpdateTableRequest().withDatabaseName(this.database).withTableInput(tableInput).withVersionId(this.glueVersionId);
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(updateTableRequest));
        }
        catch (ConcurrentModificationException e) {
            throw new CommitFailedException((Throwable)e, "Failed to commit to Glue table: %s.%s", new Object[]{this.database, this.tableName});
        }
        catch (EntityNotFoundException | InvalidInputException | ResourceNumberLimitExceededException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CommitStateUnknownException((Throwable)e);
        }
        this.shouldRefresh = true;
    }

    private Table getTable(boolean invalidateCaches) {
        return this.getGlueTable.get(new SchemaTableName(this.database, this.tableName), invalidateCaches);
    }

    public static interface GetGlueTable {
        public Table get(SchemaTableName var1, boolean var2);
    }
}

