/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.aggregation.DataSketchState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import java.util.Optional;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;

public class DataSketchStateSerializer
implements AccumulatorStateSerializer<DataSketchState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(DataSketchState state, BlockBuilder out) {
        DataSketchStateSerializer.serializeToVarbinary(state, out);
    }

    public static void serializeToVarbinary(DataSketchState state, BlockBuilder out) {
        if (state.getUpdateSketch() == null && state.getCompactSketch() == null) {
            out.appendNull();
        } else {
            Preconditions.checkArgument((state.getUpdateSketch() == null || state.getCompactSketch() == null ? 1 : 0) != 0, (Object)"A state must not have both transient accumulator and combined form set");
            CompactSketch compactSketch = Optional.ofNullable(state.getCompactSketch()).orElseGet(() -> state.getUpdateSketch().compact());
            Slice slice = Slices.wrappedBuffer((byte[])compactSketch.toByteArray());
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, DataSketchState state) {
        if (!block.isNull(index)) {
            state.setCompactSketch(DataSketchStateSerializer.deserialize(block, index));
        }
    }

    public static CompactSketch deserialize(Block block, int index) {
        Preconditions.checkArgument((!block.isNull(index) ? 1 : 0) != 0, (Object)"Value is null");
        Slice slice = VarbinaryType.VARBINARY.getSlice(block, index);
        return CompactSketch.heapify((Memory)WritableMemory.writableWrap((byte[])slice.getBytes()));
    }
}

