/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergStatistics;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class TableStatisticsReader {
    private static final Logger log = Logger.get(TableStatisticsReader.class);
    @Deprecated
    public static final String TRINO_STATS_PREFIX = "trino.stats.ndv.";
    @Deprecated
    public static final String TRINO_STATS_NDV_FORMAT = "trino.stats.ndv.%d.ndv";
    @Deprecated
    public static final Pattern TRINO_STATS_COLUMN_ID_PATTERN = Pattern.compile(Pattern.quote("trino.stats.ndv.") + "(?<columnId>\\d+)\\..*");
    @Deprecated
    public static final Pattern TRINO_STATS_NDV_PATTERN = Pattern.compile(Pattern.quote("trino.stats.ndv.") + "(?<columnId>\\d+)\\.ndv");
    public static final String APACHE_DATASKETCHES_THETA_V1_NDV_PROPERTY = "ndv";

    private TableStatisticsReader() {
    }

    public static TableStatistics getTableStatistics(TypeManager typeManager, ConnectorSession session, IcebergTableHandle tableHandle, Table icebergTable) {
        return TableStatisticsReader.makeTableStatistics(typeManager, icebergTable, tableHandle.getSnapshotId(), tableHandle.getEnforcedPredicate(), tableHandle.getUnenforcedPredicate(), IcebergSessionProperties.isExtendedStatisticsEnabled(session));
    }

    @VisibleForTesting
    public static TableStatistics makeTableStatistics(TypeManager typeManager, Table icebergTable, Optional<Long> snapshot, TupleDomain<IcebergColumnHandle> enforcedConstraint, TupleDomain<IcebergColumnHandle> unenforcedConstraint, boolean extendedStatisticsEnabled) {
        if (snapshot.isEmpty()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        long snapshotId = snapshot.get();
        TupleDomain effectivePredicate = enforcedConstraint.intersect(unenforcedConstraint);
        if (effectivePredicate.isNone()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        Schema icebergTableSchema = icebergTable.schema();
        List columns = icebergTableSchema.columns();
        List<IcebergColumnHandle> columnHandles = IcebergUtil.getColumns(icebergTableSchema, typeManager);
        Map idToColumnHandle = columnHandles.stream().collect(Collectors.toUnmodifiableMap(IcebergColumnHandle::getId, Function.identity()));
        Map<Integer, Type> idToType = columns.stream().map(column -> Maps.immutableEntry((Object)column.fieldId(), (Object)column.type())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        TableScan tableScan = (TableScan)((TableScan)icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)effectivePredicate.filter((column, domain) -> !IcebergMetadataColumn.isMetadataColumnId(column.getId()))))).useSnapshot(snapshotId).includeColumnStats();
        IcebergStatistics.Builder icebergStatisticsBuilder = new IcebergStatistics.Builder(columns, typeManager);
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> icebergStatisticsBuilder.acceptDataFile((DataFile)fileScanTask.file(), fileScanTask.spec()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        IcebergStatistics summary = icebergStatisticsBuilder.build();
        if (summary.getFileCount() == 0L) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        Map<Integer, Long> ndvs = TableStatisticsReader.readNdvs(icebergTable, snapshotId, idToColumnHandle.keySet(), extendedStatisticsEnabled);
        ImmutableMap.Builder columnHandleBuilder = ImmutableMap.builder();
        double recordCount = summary.getRecordCount();
        for (Map.Entry columnHandleTuple : idToColumnHandle.entrySet()) {
            Long columnSize;
            IcebergColumnHandle columnHandle = (IcebergColumnHandle)columnHandleTuple.getValue();
            int fieldId = columnHandle.getId();
            ColumnStatistics.Builder columnBuilder = new ColumnStatistics.Builder();
            Long nullCount = summary.getNullCounts().get(fieldId);
            if (nullCount != null) {
                columnBuilder.setNullsFraction(Estimate.of((double)((double)nullCount.longValue() / recordCount)));
            }
            if (idToType.get(columnHandleTuple.getKey()).typeId() == Type.TypeID.FIXED) {
                Types.FixedType fixedType = (Types.FixedType)idToType.get(columnHandleTuple.getKey());
                long columnSize2 = fixedType.length();
                columnBuilder.setDataSize(Estimate.of((double)columnSize2));
            } else if (summary.getColumnSizes() != null && (columnSize = summary.getColumnSizes().get(fieldId)) != null && !(columnHandle.getBaseType() instanceof FixedWidthType)) {
                if (columnHandle.getBaseType() == VarcharType.VARCHAR) {
                    columnSize = (long)((double)columnSize.longValue() * 2.7);
                } else if (columnHandle.getBaseType() == VarbinaryType.VARBINARY) {
                    columnSize = (long)((double)columnSize.longValue() * 1.4);
                }
                columnBuilder.setDataSize(Estimate.of((double)columnSize.longValue()));
            }
            Object min = summary.getMinValues().get(fieldId);
            Object max = summary.getMaxValues().get(fieldId);
            if (min != null && max != null) {
                columnBuilder.setRange(DoubleRange.from((io.trino.spi.type.Type)columnHandle.getType(), (Object)min, (Object)max));
            }
            columnBuilder.setDistinctValuesCount(Optional.ofNullable(ndvs.get(fieldId)).map(Estimate::of).orElseGet(Estimate::unknown));
            columnHandleBuilder.put((Object)columnHandle, (Object)columnBuilder.build());
        }
        return new TableStatistics(Estimate.of((double)recordCount), (Map)columnHandleBuilder.buildOrThrow());
    }

    private static Map<Integer, Long> readNdvs(Table icebergTable, long snapshotId, Set<Integer> columnIds, boolean extendedStatisticsEnabled) {
        if (!extendedStatisticsEnabled) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder ndvByColumnId = ImmutableMap.builder();
        HashSet<Integer> remainingColumnIds = new HashSet<Integer>(columnIds);
        TableStatisticsReader.getLatestStatisticsFile(icebergTable, snapshotId).ifPresent(statisticsFile -> {
            Map thetaBlobsByFieldId = (Map)statisticsFile.blobMetadata().stream().filter(blobMetadata -> blobMetadata.type().equals("apache-datasketches-theta-v1")).filter(blobMetadata -> blobMetadata.fields().size() == 1).filter(blobMetadata -> remainingColumnIds.contains(Iterables.getOnlyElement((Iterable)blobMetadata.fields()))).collect(ImmutableMap.toImmutableMap(blobMetadata -> (Integer)Iterables.getOnlyElement((Iterable)blobMetadata.fields()), Function.identity()));
            for (Map.Entry entry : thetaBlobsByFieldId.entrySet()) {
                int fieldId = (Integer)entry.getKey();
                BlobMetadata blobMetadata2 = (BlobMetadata)entry.getValue();
                String ndv = (String)blobMetadata2.properties().get(APACHE_DATASKETCHES_THETA_V1_NDV_PROPERTY);
                if (ndv == null) {
                    log.debug("Blob %s is missing %s property", new Object[]{blobMetadata2.type(), APACHE_DATASKETCHES_THETA_V1_NDV_PROPERTY});
                    remainingColumnIds.remove(fieldId);
                    continue;
                }
                remainingColumnIds.remove(fieldId);
                ndvByColumnId.put((Object)fieldId, (Object)Long.parseLong(ndv));
            }
        });
        Iterator properties = icebergTable.properties().entrySet().iterator();
        while (!remainingColumnIds.isEmpty() && properties.hasNext()) {
            int columnId;
            Matcher matcher;
            Map.Entry entry = properties.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(TRINO_STATS_PREFIX) || !(matcher = TRINO_STATS_NDV_PATTERN.matcher(key)).matches() || !remainingColumnIds.remove(columnId = Integer.parseInt(matcher.group("columnId")))) continue;
            long ndv = Long.parseLong(value);
            ndvByColumnId.put((Object)columnId, (Object)ndv);
        }
        return ndvByColumnId.buildOrThrow();
    }

    public static Optional<StatisticsFile> getLatestStatisticsFile(Table icebergTable, long snapshotId) {
        if (icebergTable.statisticsFiles().isEmpty()) {
            return Optional.empty();
        }
        Map statsFileBySnapshot = icebergTable.statisticsFiles().stream().collect(Collectors.toMap(StatisticsFile::snapshotId, Function.identity(), (file1, file2) -> {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Table '%s' has duplicate statistics files '%s' and '%s' for snapshot ID %s".formatted(icebergTable, file1.path(), file2.path(), file1.snapshotId()));
        }));
        return Streams.stream(TableStatisticsReader.walkSnapshots(icebergTable, snapshotId)).map(statsFileBySnapshot::get).filter(Objects::nonNull).findFirst();
    }

    private static Iterator<Long> walkSnapshots(final Table icebergTable, long startingSnapshotId) {
        return new AbstractSequentialIterator<Long>(Long.valueOf(startingSnapshotId)){

            protected Long computeNext(Long previous) {
                Objects.requireNonNull(previous, "previous is null");
                Snapshot snapshot = icebergTable.snapshot(previous.longValue());
                if (snapshot == null) {
                    return null;
                }
                if (snapshot.parentId() == null) {
                    return null;
                }
                return (Long)Verify.verifyNotNull((Object)snapshot.parentId(), (String)"snapshot.parentId()", (Object[])new Object[0]);
            }
        };
    }
}

