/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.Metrics;

public class MetricsWrapper {
    private final Metrics metrics;

    @JsonCreator
    public MetricsWrapper(@JsonProperty(value="recordCount") Long recordCount, @JsonProperty(value="columnSizes") Map<Integer, Long> columnSizes, @JsonProperty(value="valueCounts") Map<Integer, Long> valueCounts, @JsonProperty(value="nullValueCounts") Map<Integer, Long> nullValueCounts, @JsonProperty(value="nanValueCounts") Map<Integer, Long> nanValueCounts, @JsonProperty(value="lowerBounds") Map<Integer, ByteBuffer> lowerBounds, @JsonProperty(value="upperBounds") Map<Integer, ByteBuffer> upperBounds) {
        this(new Metrics(recordCount, columnSizes, valueCounts, nullValueCounts, nanValueCounts, lowerBounds, upperBounds));
    }

    public MetricsWrapper(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @JsonProperty
    public Long recordCount() {
        return this.metrics.recordCount();
    }

    @JsonProperty
    public Map<Integer, Long> columnSizes() {
        return this.metrics.columnSizes();
    }

    @JsonProperty
    public Map<Integer, Long> valueCounts() {
        return this.metrics.valueCounts();
    }

    @JsonProperty
    public Map<Integer, Long> nullValueCounts() {
        return this.metrics.nullValueCounts();
    }

    @JsonProperty
    public Map<Integer, Long> nanValueCounts() {
        return this.metrics.nanValueCounts();
    }

    @JsonProperty
    public Map<Integer, ByteBuffer> lowerBounds() {
        return this.metrics.lowerBounds();
    }

    @JsonProperty
    public Map<Integer, ByteBuffer> upperBounds() {
        return this.metrics.upperBounds();
    }
}

