/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.hdfs.HdfsModule;
import io.trino.hdfs.authentication.HdfsAuthenticationModule;
import io.trino.hdfs.azure.HiveAzureModule;
import io.trino.hdfs.gcs.HiveGcsModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.IcebergAnalyzeProperties;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergMaterializedViewAdditionalProperties;
import io.trino.plugin.iceberg.IcebergModule;
import io.trino.plugin.iceberg.IcebergSchemaProperties;
import io.trino.plugin.iceberg.IcebergSecurityModule;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergTransactionManager;
import io.trino.plugin.iceberg.catalog.IcebergCatalogModule;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalIcebergConnectorFactory {
    private InternalIcebergConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module, Optional<Module> icebergCatalogModule, Optional<TrinoFileSystemFactory> fileSystemFactory) {
        ClassLoader classLoader = InternalIcebergConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule("io.trino.plugin.iceberg", "trino.plugin.iceberg"), new JsonModule(), new IcebergModule(), new IcebergSecurityModule(), icebergCatalogModule.orElse((Module)new IcebergCatalogModule()), new HdfsModule(), new HiveGcsModule(), new HiveAzureModule(), new HdfsAuthenticationModule(), new MBeanServerModule(), fileSystemFactory.map(factory -> binder -> binder.bind(TrinoFileSystemFactory.class).toInstance(factory)).orElseGet(FileSystemModule::new), binder -> {
                binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
                binder.bind(Tracer.class).toInstance((Object)context.getTracer());
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(CatalogHandle.class).toInstance((Object)context.getCatalogHandle());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
            }, module});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            IcebergTransactionManager transactionManager = (IcebergTransactionManager)injector.getInstance(IcebergTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            Set sessionPropertiesProviders = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SessionPropertiesProvider>>(){}));
            IcebergTableProperties icebergTableProperties = (IcebergTableProperties)injector.getInstance(IcebergTableProperties.class);
            IcebergMaterializedViewAdditionalProperties materializedViewAdditionalProperties = (IcebergMaterializedViewAdditionalProperties)injector.getInstance(IcebergMaterializedViewAdditionalProperties.class);
            IcebergAnalyzeProperties icebergAnalyzeProperties = (IcebergAnalyzeProperties)injector.getInstance(IcebergAnalyzeProperties.class);
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            Set tableProcedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<TableProcedureMetadata>>(){}));
            Optional accessControl = (Optional)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<ConnectorAccessControl>>(){}));
            List materializedViewProperties = (List)Stream.of(icebergTableProperties.getTableProperties(), materializedViewAdditionalProperties.getMaterializedViewProperties()).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
            IcebergConnector icebergConnector = new IcebergConnector(injector, lifeCycleManager, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), sessionPropertiesProviders, IcebergSchemaProperties.SCHEMA_PROPERTIES, icebergTableProperties.getTableProperties(), materializedViewProperties, icebergAnalyzeProperties.getAnalyzeProperties(), accessControl, procedures, tableProcedures);
            return icebergConnector;
        }
    }
}

