/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.type.VarcharType;

public class IcebergUpdateBucketFunction
implements BucketFunction {
    private final int bucketCount;

    public IcebergUpdateBucketFunction(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        Block row = (Block)page.getBlock(0).getObject(position, Block.class);
        Slice value = VarcharType.VARCHAR.getSlice(row, 0);
        return (value.hashCode() & Integer.MAX_VALUE) % this.bucketCount;
    }
}

