/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.iceberg.TableType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcebergTableName {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:\\$(?<type>[^@]+))?");

    private IcebergTableName() {
    }

    public static String tableNameWithType(String tableName, TableType tableType) {
        Objects.requireNonNull(tableName, "tableName is null");
        return tableName + "$" + tableType.name().toLowerCase(Locale.ENGLISH);
    }

    public static String tableNameFrom(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        return match.group("table");
    }

    public static Optional<TableType> tableTypeFrom(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        String typeString = match.group("type");
        if (typeString == null) {
            return Optional.of(TableType.DATA);
        }
        try {
            TableType parsedType = TableType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
            if (parsedType == TableType.DATA) {
                return Optional.empty();
            }
            return Optional.of(parsedType);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static boolean isDataTable(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        String typeString = match.group("type");
        return typeString == null;
    }
}

