/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.Type;

public final class IcebergParquetColumnIOConverter {
    private IcebergParquetColumnIOConverter() {
    }

    public static Optional<Field> constructField(FieldContext context, ColumnIO columnIO) {
        Objects.requireNonNull(context, "context is null");
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = columnIO.getRepetitionLevel();
        int definitionLevel = columnIO.getDefinitionLevel();
        Type type = context.getType();
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List<ColumnIdentity> subColumns = context.getColumnIdentity().getChildren();
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = rowType.getFields();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field rowField = (RowType.Field)fields.get(i);
                ColumnIdentity fieldIdentity = subColumns.get(i);
                Optional<Field> field = IcebergParquetColumnIOConverter.constructField(new FieldContext(rowField.getType(), fieldIdentity), ParquetTypeUtils.lookupColumnById((GroupColumnIO)groupColumnIO, (int)fieldIdentity.getId()));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn((GroupColumnIO)groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            List<ColumnIdentity> subColumns = context.getColumnIdentity().getChildren();
            Preconditions.checkArgument((subColumns.size() == 2 ? 1 : 0) != 0, (String)"Not a map: %s", (Object)context);
            ColumnIdentity keyIdentity = subColumns.get(0);
            ColumnIdentity valueIdentity = subColumns.get(1);
            Optional<Field> keyField = IcebergParquetColumnIOConverter.constructField(new FieldContext(mapType.getKeyType(), keyIdentity), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = IcebergParquetColumnIOConverter.constructField(new FieldContext(mapType.getValueType(), valueIdentity), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            List<ColumnIdentity> subColumns = context.getColumnIdentity().getChildren();
            Preconditions.checkArgument((subColumns.size() == 1 ? 1 : 0) != 0, (String)"Not an array: %s", (Object)context);
            ColumnIdentity elementIdentity = (ColumnIdentity)Iterables.getOnlyElement(subColumns);
            Optional<Field> field = IcebergParquetColumnIOConverter.constructField(new FieldContext(arrayType.getElementType(), elementIdentity), ParquetTypeUtils.getArrayElementColumn((ColumnIO)groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        return Optional.of(new PrimitiveField(type, required, primitiveColumnIO.getColumnDescriptor(), primitiveColumnIO.getId()));
    }

    public static class FieldContext {
        private final Type type;
        private final ColumnIdentity columnIdentity;

        public FieldContext(Type type, ColumnIdentity columnIdentity) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.columnIdentity = Objects.requireNonNull(columnIdentity, "columnIdentity is null");
        }

        public Type getType() {
            return this.type;
        }

        public ColumnIdentity getColumnIdentity() {
            return this.columnIdentity;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("columnIdentity", (Object)this.columnIdentity).toString();
        }
    }
}

