/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import com.google.inject.Inject;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.ExtraCredentialConfig;
import io.trino.plugin.jdbc.credential.ForExtraCredentialProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExtraCredentialProvider
implements CredentialProvider {
    private final Optional<String> userCredentialName;
    private final Optional<String> passwordCredentialName;
    private final CredentialProvider delegate;

    @Inject
    public ExtraCredentialProvider(ExtraCredentialConfig config, @ForExtraCredentialProvider CredentialProvider delegate) {
        this(config.getUserCredentialName(), config.getPasswordCredentialName(), delegate);
    }

    public ExtraCredentialProvider(Optional<String> userCredentialName, Optional<String> passwordCredentialName, CredentialProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.userCredentialName = Objects.requireNonNull(userCredentialName, "userCredentialName is null");
        this.passwordCredentialName = Objects.requireNonNull(passwordCredentialName, "passwordCredentialName is null");
    }

    @Override
    public Optional<String> getConnectionUser(Optional<ConnectorIdentity> jdbcIdentity) {
        Map extraCredentials;
        if (jdbcIdentity.isPresent() && this.userCredentialName.isPresent() && (extraCredentials = jdbcIdentity.get().getExtraCredentials()).containsKey(this.userCredentialName.get())) {
            return Optional.of((String)extraCredentials.get(this.userCredentialName.get()));
        }
        return this.delegate.getConnectionUser(jdbcIdentity);
    }

    @Override
    public Optional<String> getConnectionPassword(Optional<ConnectorIdentity> jdbcIdentity) {
        Map extraCredentials;
        if (jdbcIdentity.isPresent() && this.passwordCredentialName.isPresent() && (extraCredentials = jdbcIdentity.get().getExtraCredentials()).containsKey(this.passwordCredentialName.get())) {
            return Optional.of((String)extraCredentials.get(this.passwordCredentialName.get()));
        }
        return this.delegate.getConnectionPassword(jdbcIdentity);
    }
}

