/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.propagation;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Splitter;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.SpanContext;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.SpanId;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.TraceId;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.TraceOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.Tracestate;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.propagation.SpanContextParseException;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.propagation.TextFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TraceContextFormat
extends TextFormat {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    @VisibleForTesting
    static final String TRACEPARENT = "traceparent";
    @VisibleForTesting
    static final String TRACESTATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int TRACE_OPTION_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Splitter TRACESTATE_ENTRY_DELIMITER_SPLITTER = Splitter.on(Pattern.compile("[ \t]*,[ \t]*"));

    @Override
    public List<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(SpanContext spanContext, C carrier, TextFormat.Setter<C> setter) {
        Preconditions.checkNotNull(spanContext, "spanContext");
        Preconditions.checkNotNull(setter, "setter");
        Preconditions.checkNotNull(carrier, "carrier");
        char[] chars = new char[55];
        chars[0] = VERSION.charAt(0);
        chars[1] = VERSION.charAt(1);
        chars[2] = 45;
        spanContext.getTraceId().copyLowerBase16To(chars, 3);
        chars[35] = 45;
        spanContext.getSpanId().copyLowerBase16To(chars, 36);
        chars[52] = 45;
        spanContext.getTraceOptions().copyLowerBase16To(chars, 53);
        setter.put(carrier, TRACEPARENT, new String(chars));
        List<Tracestate.Entry> entries = spanContext.getTracestate().getEntries();
        if (entries.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Tracestate.Entry entry : entries) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        setter.put(carrier, TRACESTATE, stringBuilder.toString());
    }

    @Override
    public <C> SpanContext extract(C carrier, TextFormat.Getter<C> getter) throws SpanContextParseException {
        TraceOptions traceOptions;
        SpanId spanId;
        TraceId traceId;
        Preconditions.checkNotNull(carrier, "carrier");
        Preconditions.checkNotNull(getter, "getter");
        String traceparent = getter.get(carrier, TRACEPARENT);
        if (traceparent == null) {
            throw new SpanContextParseException("Traceparent not present");
        }
        try {
            Preconditions.checkArgument(traceparent.charAt(52) == '-' && (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-', "Missing or malformed TRACEPARENT.");
            traceId = TraceId.fromLowerBase16(traceparent, 3);
            spanId = SpanId.fromLowerBase16(traceparent, 36);
            traceOptions = TraceOptions.fromLowerBase16(traceparent, 53);
        }
        catch (IllegalArgumentException e) {
            throw new SpanContextParseException("Invalid traceparent: " + traceparent, e);
        }
        String tracestate = getter.get(carrier, TRACESTATE);
        try {
            if (tracestate == null || tracestate.isEmpty()) {
                return SpanContext.create(traceId, spanId, traceOptions, TRACESTATE_DEFAULT);
            }
            Tracestate.Builder tracestateBuilder = Tracestate.builder();
            List<String> listMembers = TRACESTATE_ENTRY_DELIMITER_SPLITTER.splitToList(tracestate);
            Preconditions.checkArgument(listMembers.size() <= 32, "Tracestate has too many elements.");
            for (int i = listMembers.size() - 1; i >= 0; --i) {
                String listMember = listMembers.get(i);
                int index = listMember.indexOf(61);
                Preconditions.checkArgument(index != -1, "Invalid tracestate list-member format.");
                tracestateBuilder.set(listMember.substring(0, index), listMember.substring(index + 1, listMember.length()));
            }
            return SpanContext.create(traceId, spanId, traceOptions, tracestateBuilder.build());
        }
        catch (IllegalArgumentException e) {
            throw new SpanContextParseException("Invalid tracestate: " + tracestate, e);
        }
    }
}

