/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.util.DirectBufferPool;

public class RemoteReadRequestChain
extends ReadRequestChain {
    final FSDataInputStream inputStream;
    private DirectBufferPool bufferPool;
    private int directBufferSize;
    private byte[] affixBuffer;
    private long extraRead;
    private long totalRequestedRead;
    private long warmupPenalty;
    private int blockSize;
    private BookKeeperFactory bookKeeperFactory;
    private static final Log log = LogFactory.getLog(RemoteReadRequestChain.class);
    private String localFile;

    public RemoteReadRequestChain(FSDataInputStream inputStream, String remotePath, int generationNumber, DirectBufferPool bufferPool, Configuration conf, byte[] affixBuffer, BookKeeperFactory bookKeeperFactory) {
        super(generationNumber);
        this.inputStream = inputStream;
        this.bufferPool = bufferPool;
        this.directBufferSize = CacheConfig.getDiskReadBufferSize(conf);
        this.affixBuffer = affixBuffer;
        this.blockSize = affixBuffer.length;
        this.localFile = CacheUtil.getLocalPath(remotePath, conf, generationNumber);
        this.bookKeeperFactory = bookKeeperFactory;
    }

    @VisibleForTesting
    public RemoteReadRequestChain(FSDataInputStream inputStream, String remoteFileName, int generationNumber, Configuration conf) {
        this(inputStream, remoteFileName, generationNumber, new DirectBufferPool(), conf, new byte[100], new BookKeeperFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Remote read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        if (this.readRequests.size() == 0) {
            return 0L;
        }
        File file = new File(this.localFile);
        if (!file.exists()) {
            throw new IOException(String.format("File does not exists %s", this.localFile));
        }
        FileChannel fileChannel = new FileOutputStream(new RandomAccessFile(file, "rw").getFD()).getChannel();
        ByteBuffer directBuffer = this.bufferPool.getBuffer(this.directBufferSize);
        Preconditions.checkState(directBuffer != null, "directBuffer could not be allocated");
        try {
            for (ReadRequest readRequest : this.readRequests) {
                int readBytes;
                if (this.cancelled) {
                    this.propagateCancel(this.getClass().getName());
                }
                log.debug((Object)String.format("Executing ReadRequest: [%d, %d, %d, %d, %d]", readRequest.getBackendReadStart(), readRequest.getBackendReadEnd(), readRequest.getActualReadStart(), readRequest.getActualReadEnd(), readRequest.getDestBufferOffset()));
                int prefixBufferLength = (int)(readRequest.getActualReadStart() - readRequest.getBackendReadStart());
                int suffixBufferLength = (int)(readRequest.getBackendReadEnd() - readRequest.getActualReadEnd());
                log.debug((Object)String.format("PrefixLength: %d SuffixLength: %d", prefixBufferLength, suffixBufferLength));
                if (prefixBufferLength > 0) {
                    this.inputStream.seek(readRequest.backendReadStart);
                    log.debug((Object)String.format("Trying to Read %d bytes into prefix buffer", prefixBufferLength));
                    this.extraRead += (long)RemoteReadRequestChain.readIntoBuffer(this.affixBuffer, 0, prefixBufferLength, this.inputStream);
                    int written = this.copyIntoCache(fileChannel, directBuffer, this.affixBuffer, 0, prefixBufferLength, readRequest.backendReadStart);
                    log.debug((Object)String.format("Copied %d prefix bytes into cache", written));
                }
                log.debug((Object)String.format("Trying to Read %d bytes into destination buffer", readRequest.getActualReadLengthIntUnsafe()));
                if (prefixBufferLength > 0 || suffixBufferLength > 0) {
                    this.inputStream.seek(readRequest.actualReadStart);
                    readBytes = RemoteReadRequestChain.readIntoBuffer(readRequest.getDestBuffer(), readRequest.destBufferOffset, readRequest.getActualReadLengthIntUnsafe(), this.inputStream);
                } else {
                    this.inputStream.readFully(readRequest.actualReadStart, readRequest.getDestBuffer(), readRequest.destBufferOffset, readRequest.getActualReadLengthIntUnsafe());
                    readBytes = readRequest.getActualReadLengthIntUnsafe();
                }
                int written = this.copyIntoCache(fileChannel, directBuffer, readRequest.destBuffer, readRequest.destBufferOffset, readRequest.getActualReadLengthIntUnsafe(), readRequest.actualReadStart);
                log.debug((Object)String.format("Copied %d requested bytes into cache", written));
                this.totalRequestedRead += (long)readRequest.getActualReadLengthIntUnsafe();
                if (suffixBufferLength <= 0) continue;
                log.debug((Object)String.format("Trying to Read %d bytes into suffix buffer", suffixBufferLength));
                this.inputStream.seek(readRequest.actualReadEnd);
                this.extraRead += (long)RemoteReadRequestChain.readIntoBuffer(this.affixBuffer, 0, suffixBufferLength, this.inputStream);
                written = this.copyIntoCache(fileChannel, directBuffer, this.affixBuffer, 0, suffixBufferLength, readRequest.actualReadEnd);
                log.debug((Object)String.format("Copied %d suffix bytes into cache", written));
            }
            log.debug((Object)String.format("Read %d bytes from remote localFile, added %d to destination buffer", this.extraRead + this.totalRequestedRead, this.totalRequestedRead));
            Long l = this.totalRequestedRead;
            return l;
        }
        finally {
            this.bufferPool.returnBuffer(directBuffer);
            fileChannel.close();
        }
    }

    public static int readIntoBuffer(byte[] destBuffer, int destBufferOffset, int length, FSDataInputStream inputStream) throws IOException {
        int nread;
        int nbytes;
        for (nread = 0; nread < length; nread += nbytes) {
            nbytes = inputStream.read(destBuffer, destBufferOffset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
        return nread;
    }

    private int copyIntoCache(FileChannel fileChannel, ByteBuffer directBuffer, byte[] destBuffer, int destBufferOffset, int length, long cacheReadStart) throws IOException {
        int nwrite;
        log.debug((Object)String.format("Trying to copy [%d - %d] bytes into cache with offset %d into localFile %s", cacheReadStart, cacheReadStart + (long)length, destBufferOffset, this.localFile));
        long start = System.nanoTime();
        int writtenSoFar = 0;
        for (int leftToWrite = length; leftToWrite > 0; leftToWrite -= nwrite) {
            int writeInThisCycle = Math.min(leftToWrite, directBuffer.capacity());
            directBuffer.clear();
            directBuffer.put(destBuffer, destBufferOffset + writtenSoFar, writeInThisCycle);
            directBuffer.flip();
            nwrite = fileChannel.write(directBuffer, cacheReadStart + (long)writtenSoFar);
            writtenSoFar += nwrite;
        }
        this.warmupPenalty += System.nanoTime() - start;
        return writtenSoFar;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setRemoteRRCDataRead(this.extraRead + this.totalRequestedRead).setRemoteRRCExtraDataRead(this.extraRead).setRemoteRRCWarmupTime(this.warmupPenalty).setRemoteRRCRequests(this.requests);
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        try (RetryingPooledBookkeeperClient client = this.bookKeeperFactory.createBookKeeperClient(conf);){
            for (ReadRequest readRequest : this.readRequests) {
                log.debug((Object)("Setting cached from : " + this.toBlock(readRequest.getBackendReadStart()) + " block to : " + (this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L)));
                client.setAllCached(remotePath, fileSize, lastModified, this.toBlock(readRequest.getBackendReadStart()), this.toBlock(readRequest.getBackendReadEnd() - 1L) + 1L, this.generationNumber);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Could not update BookKeeper about newly cached blocks", (Throwable)e);
        }
    }

    private long toBlock(long pos) {
        return pos / (long)this.blockSize;
    }
}

