/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Inject;
import io.trino.plugin.base.security.ForwardingConnectorAccessControl;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.util.SystemTables;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SystemTableAwareAccessControl
extends ForwardingConnectorAccessControl {
    private final ConnectorAccessControl delegate;
    private final Set<SystemTableProvider> systemTableProviders;

    @Inject
    public SystemTableAwareAccessControl(ConnectorAccessControl delegate, Set<SystemTableProvider> systemTableProviders) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.systemTableProviders = Objects.requireNonNull(systemTableProviders, "systemTableProviders is null");
    }

    protected ConnectorAccessControl delegate() {
        return this.delegate;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        Optional<SchemaTableName> sourceTableName = SystemTables.getSourceTableNameFromSystemTable(this.systemTableProviders, tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanShowColumns(context, sourceTableName.get());
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denyShowColumns((String)tableName.toString());
            }
        }
        this.delegate.checkCanShowColumns(context, tableName);
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        Optional<SchemaTableName> sourceTableName = SystemTables.getSourceTableNameFromSystemTable(this.systemTableProviders, tableName);
        if (sourceTableName.isPresent()) {
            return this.filterColumns(context, sourceTableName.get(), columns);
        }
        return this.delegate.filterColumns(context, tableName, columns);
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        Optional<SchemaTableName> sourceTableName = SystemTables.getSourceTableNameFromSystemTable(this.systemTableProviders, tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanSelectFromColumns(context, sourceTableName.get(), columnNames);
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denySelectTable((String)tableName.toString());
            }
        }
        this.delegate.checkCanSelectFromColumns(context, tableName, columnNames);
    }
}

