/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Inject;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetastore;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.security.RoleGrant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SemiTransactionalSqlStandardAccessControlMetastore
implements SqlStandardAccessControlMetastore {
    private final HiveTransactionManager transactionManager;

    @Inject
    public SemiTransactionalSqlStandardAccessControlMetastore(HiveTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSecurityContext context, HivePrincipal principal) {
        SemiTransactionalHiveMetastore metastore = this.transactionManager.get(context.getTransactionHandle(), context.getIdentity()).getMetastore();
        return metastore.listRoleGrants(principal);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(ConnectorSecurityContext context, String databaseName, String tableName, Optional<HivePrincipal> principal) {
        SemiTransactionalHiveMetastore metastore = this.transactionManager.get(context.getTransactionHandle(), context.getIdentity()).getMetastore();
        return metastore.listTablePrivileges(databaseName, tableName, principal);
    }

    @Override
    public Optional<Database> getDatabase(ConnectorSecurityContext context, String databaseName) {
        SemiTransactionalHiveMetastore metastore = this.transactionManager.get(context.getTransactionHandle(), context.getIdentity()).getMetastore();
        return metastore.getDatabase(databaseName);
    }
}

