/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveWriteStatisticsExecutor;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.plugin.hive.metastore.thrift.TranslateHiveViews;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class ThriftHiveMetastoreFactory
implements ThriftMetastoreFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final IdentityAwareMetastoreClientFactory metastoreClientFactory;
    private final double backoffScaleFactor;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final Duration maxRetryTime;
    private final Duration maxWaitForLock;
    private final int maxRetries;
    private final boolean impersonationEnabled;
    private final boolean deleteFilesOnDrop;
    private final boolean translateHiveViews;
    private final boolean assumeCanonicalPartitionKeys;
    private final boolean useSparkTableStatisticsFallback;
    private final ExecutorService writeStatisticsExecutor;
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();

    @Inject
    public ThriftHiveMetastoreFactory(IdentityAwareMetastoreClientFactory metastoreClientFactory, @HideDeltaLakeTables boolean hideDeltaLakeTables, @TranslateHiveViews boolean translateHiveViews, ThriftMetastoreConfig thriftConfig, HdfsEnvironment hdfsEnvironment, @ThriftHiveWriteStatisticsExecutor ExecutorService writeStatisticsExecutor) {
        this.metastoreClientFactory = Objects.requireNonNull(metastoreClientFactory, "metastoreClientFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.backoffScaleFactor = thriftConfig.getBackoffScaleFactor();
        this.minBackoffDelay = thriftConfig.getMinBackoffDelay();
        this.maxBackoffDelay = thriftConfig.getMaxBackoffDelay();
        this.maxRetryTime = thriftConfig.getMaxRetryTime();
        this.maxRetries = thriftConfig.getMaxRetries();
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
        this.deleteFilesOnDrop = thriftConfig.isDeleteFilesOnDrop();
        this.translateHiveViews = translateHiveViews;
        Preconditions.checkArgument((!hideDeltaLakeTables ? 1 : 0) != 0, (Object)"Hiding Delta Lake tables is not supported");
        this.maxWaitForLock = thriftConfig.getMaxWaitForTransactionLock();
        this.assumeCanonicalPartitionKeys = thriftConfig.isAssumeCanonicalPartitionKeys();
        this.useSparkTableStatisticsFallback = thriftConfig.isUseSparkTableStatisticsFallback();
        this.writeStatisticsExecutor = Objects.requireNonNull(writeStatisticsExecutor, "writeStatisticsExecutor is null");
    }

    @Managed
    @Flatten
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    @Override
    public ThriftMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return new ThriftHiveMetastore(identity, this.hdfsEnvironment, this.metastoreClientFactory, this.backoffScaleFactor, this.minBackoffDelay, this.maxBackoffDelay, this.maxRetryTime, this.maxWaitForLock, this.maxRetries, this.deleteFilesOnDrop, this.translateHiveViews, this.assumeCanonicalPartitionKeys, this.useSparkTableStatisticsFallback, this.stats, this.writeStatisticsExecutor);
    }
}

