/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.metastore.Database;
import io.trino.spi.security.PrincipalType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DatabaseMetadata {
    private final Optional<String> writerVersion;
    private final Optional<String> location;
    private final Optional<String> ownerName;
    private final Optional<PrincipalType> ownerType;
    private final Map<String, String> parameters;

    @JsonCreator
    public DatabaseMetadata(@JsonProperty(value="writerVersion") Optional<String> writerVersion, @JsonProperty(value="location") Optional<String> location, @JsonProperty(value="ownerName") Optional<String> ownerName, @JsonProperty(value="ownerType") Optional<PrincipalType> ownerType, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.writerVersion = Objects.requireNonNull(writerVersion, "writerVersion is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.ownerName = Objects.requireNonNull(ownerName, "ownerName is null");
        this.ownerType = Objects.requireNonNull(ownerType, "ownerType is null");
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    public DatabaseMetadata(String currentVersion, Database database) {
        this.writerVersion = Optional.of(Objects.requireNonNull(currentVersion, "currentVersion is null"));
        this.location = database.getLocation();
        this.ownerName = database.getOwnerName();
        this.ownerType = database.getOwnerType();
        this.parameters = database.getParameters();
    }

    @JsonProperty
    public Optional<String> getWriterVersion() {
        return this.writerVersion;
    }

    @JsonProperty
    public Optional<String> getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<String> getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty
    public Optional<PrincipalType> getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Database toDatabase(String databaseName, String databaseMetadataDirectory) {
        return Database.builder().setDatabaseName(databaseName).setLocation(Optional.of(this.location.orElse(databaseMetadataDirectory))).setOwnerName(this.ownerName).setOwnerType(this.ownerType).setParameters(this.parameters).build();
    }
}

