/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena;

import io.trino.plugin.hive.aws.athena.projection.Projection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class PartitionProjectionProperties {
    static final String TABLE_PROJECTION_ENABLED_SUFFIX = "enabled";
    static final String TABLE_PROJECTION_IGNORE_SUFFIX = "ignore";
    static final String COLUMN_PROJECTION_TYPE_SUFFIX = "type";
    static final String COLUMN_PROJECTION_VALUES_SUFFIX = "values";
    static final String COLUMN_PROJECTION_RANGE_SUFFIX = "range";
    static final String COLUMN_PROJECTION_INTERVAL_SUFFIX = "interval";
    static final String COLUMN_PROJECTION_DIGITS_SUFFIX = "digits";
    static final String COLUMN_PROJECTION_FORMAT_SUFFIX = "format";
    private static final String METASTORE_PROPERTY_SEPARATOR = ".";
    private static final String METASTORE_PROPERTY_PREFIX = "projection.";
    static final String METASTORE_PROPERTY_PROJECTION_INTERVAL_UNIT_SUFFIX = "interval.unit";
    static final String METASTORE_PROPERTY_PROJECTION_ENABLED = "projection.enabled";
    static final String METASTORE_PROPERTY_PROJECTION_LOCATION_TEMPLATE = "storage.location.template";
    static final String METASTORE_PROPERTY_PROJECTION_IGNORE = "trino.partition_projection.ignore";
    private static final String PROPERTY_KEY_SEPARATOR = "_";
    static final String PROPERTY_KEY_PREFIX = "partition_projection_";
    private static final String PROPERTY_KEY_SUFFIX_COLUMN_PROJECTION_INTERVAL_UNIT = "interval_unit";
    public static final String PARTITION_PROJECTION_ENABLED = "partition_projection_enabled";
    public static final String PARTITION_PROJECTION_LOCATION_TEMPLATE = "partition_projection_location_template";
    public static final String PARTITION_PROJECTION_IGNORE = "partition_projection_ignore";
    public static final String COLUMN_PROJECTION_TYPE = "partition_projection_type";
    public static final String COLUMN_PROJECTION_VALUES = "partition_projection_values";
    public static final String COLUMN_PROJECTION_RANGE = "partition_projection_range";
    public static final String COLUMN_PROJECTION_INTERVAL = "partition_projection_interval";
    public static final String COLUMN_PROJECTION_INTERVAL_UNIT = "partition_projection_interval_unit";
    public static final String COLUMN_PROJECTION_DIGITS = "partition_projection_digits";
    public static final String COLUMN_PROJECTION_FORMAT = "partition_projection_format";

    static String getMetastoreProjectionPropertyKey(String columnName, String propertyKeySuffix) {
        return METASTORE_PROPERTY_PREFIX + columnName + METASTORE_PROPERTY_SEPARATOR + propertyKeySuffix;
    }

    public static <T, I> T getProjectionPropertyRequiredValue(String columnName, Map<String, I> columnProjectionProperties, String propertyKey, Function<I, T> decoder) {
        return PartitionProjectionProperties.getProjectionPropertyValue(columnProjectionProperties, propertyKey, decoder).orElseThrow(() -> Projection.invalidProjectionException(columnName, String.format("Missing required property: '%s'", propertyKey)));
    }

    public static <T, I> Optional<T> getProjectionPropertyValue(Map<String, I> columnProjectionProperties, String propertyKey, Function<I, T> decoder) {
        return Optional.ofNullable(columnProjectionProperties.get(propertyKey)).map(value -> decoder.apply(value));
    }

    private PartitionProjectionProperties() {
    }
}

