/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.parquet.ParquetRecordWriter;
import io.trino.plugin.hive.util.FieldSetterFactory;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.hive.util.TextHeaderWriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class RecordFileWriter
implements FileWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RecordFileWriter.class);
    private final Path path;
    private final JobConf conf;
    private final int fieldCount;
    private final Serializer serializer;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final Object row;
    private final FieldSetterFactory.FieldSetter[] setters;
    private final long estimatedWriterMemoryUsage;
    private boolean committed;
    private long finalWrittenBytes = -1L;

    public RecordFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, DataSize estimatedWriterMemoryUsage, JobConf conf, TypeManager typeManager, DateTimeZone parquetTimeZone, ConnectorSession session) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.conf = Objects.requireNonNull(conf, "conf is null");
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(typeManager, HiveSessionProperties.getTimestampPrecision(session))).collect(Collectors.toList());
        this.fieldCount = fileColumnNames.size();
        String serde = storageFormat.getSerde();
        this.serializer = HiveWriteUtils.initializeSerializer((Configuration)conf, schema, serde);
        List<ObjectInspector> objectInspectors = HiveWriteUtils.getRowColumnInspectors(fileColumnTypes);
        this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector(fileColumnNames, objectInspectors);
        if (storageFormat.getOutputFormat().equals("org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat")) {
            Optional<TextHeaderWriter> textHeaderWriter = Optional.of(new TextHeaderWriter(this.serializer, typeManager, session, fileColumnNames));
            this.recordWriter = HiveWriteUtils.createRecordWriter(path, conf, schema, storageFormat.getOutputFormat(), session, textHeaderWriter);
        } else {
            this.recordWriter = HiveWriteUtils.createRecordWriter(path, conf, schema, storageFormat.getOutputFormat(), session, Optional.empty());
        }
        this.structFields = (List)inputColumnNames.stream().map(arg_0 -> ((SettableStructObjectInspector)this.tableInspector).getStructFieldRef(arg_0)).collect(ImmutableList.toImmutableList());
        this.row = this.tableInspector.create();
        DateTimeZone timeZone = this.recordWriter instanceof ParquetRecordWriter ? parquetTimeZone : DateTimeZone.UTC;
        FieldSetterFactory fieldSetterFactory = new FieldSetterFactory(timeZone);
        this.setters = new FieldSetterFactory.FieldSetter[this.structFields.size()];
        for (int i = 0; i < this.setters.length; ++i) {
            this.setters[i] = fieldSetterFactory.create(this.tableInspector, this.row, this.structFields.get(i), fileColumnTypes.get(this.structFields.get(i).getFieldID()));
        }
        this.estimatedWriterMemoryUsage = estimatedWriterMemoryUsage.toBytes();
    }

    @Override
    public long getWrittenBytes() {
        if (this.recordWriter instanceof ExtendedRecordWriter) {
            return ((ExtendedRecordWriter)this.recordWriter).getWrittenBytes();
        }
        if (this.committed) {
            if (this.finalWrittenBytes != -1L) {
                return this.finalWrittenBytes;
            }
            try {
                this.finalWrittenBytes = this.path.getFileSystem((Configuration)this.conf).getFileStatus(this.path).getLen();
                return this.finalWrittenBytes;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return 0L;
    }

    @Override
    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.estimatedWriterMemoryUsage;
    }

    @Override
    public void appendRows(Page dataPage) {
        for (int position = 0; position < dataPage.getPositionCount(); ++position) {
            this.appendRow(dataPage, position);
        }
    }

    public void appendRow(Page dataPage, int position) {
        for (int field = 0; field < this.fieldCount; ++field) {
            Block block = dataPage.getBlock(field);
            if (block.isNull(position)) {
                this.tableInspector.setStructFieldData(this.row, this.structFields.get(field), null);
                continue;
            }
            this.setters[field].setField(block, position);
        }
        try {
            this.recordWriter.write(this.serializer.serialize(this.row, (ObjectInspector)this.tableInspector));
        }
        catch (IOException | SerDeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
        }
    }

    @Override
    public Closeable commit() {
        try {
            this.recordWriter.close(false);
            this.committed = true;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        return RecordFileWriter.createRollbackAction(this.path, this.conf);
    }

    @Override
    public void rollback() {
        Closeable rollbackAction = RecordFileWriter.createRollbackAction(this.path, this.conf);
        try (Closeable closeable = rollbackAction;){
            this.recordWriter.close(true);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    private static Closeable createRollbackAction(Path path, JobConf conf) {
        return () -> path.getFileSystem((Configuration)conf).delete(path, false);
    }

    @Override
    public long getValidationCpuNanos() {
        return 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    public static interface ExtendedRecordWriter
    extends FileSinkOperator.RecordWriter {
        public long getWrittenBytes();
    }
}

