/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum HiveStorageFormat {
    ORC("org.apache.hadoop.hive.ql.io.orc.OrcSerde", "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    PARQUET("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    AVRO("org.apache.hadoop.hive.serde2.avro.AvroSerDe", "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCBINARY("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe", "org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCTEXT("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe", "org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    SEQUENCEFILE("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.SequenceFileInputFormat", "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    JSON("org.apache.hive.hcatalog.data.JsonSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    OPENX_JSON("org.openx.data.jsonserde.JsonSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    TEXTFILE("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    CSV("org.apache.hadoop.hive.serde2.OpenCSVSerde", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    REGEX("org.apache.hadoop.hive.serde2.RegexSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterMemoryUsage;
    private static final Map<SerdeAndInputFormat, HiveStorageFormat> HIVE_STORAGE_FORMATS;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterMemoryUsage = Objects.requireNonNull(estimatedWriterMemoryUsage, "estimatedWriterMemoryUsage is null");
    }

    public String getSerde() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterMemoryUsage() {
        return this.estimatedWriterMemoryUsage;
    }

    public boolean isSplittable(String path) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ORC, PARQUET, AVRO, RCBINARY, RCTEXT, SEQUENCEFILE -> true;
            case JSON, OPENX_JSON, TEXTFILE, CSV, REGEX -> CompressionKind.forFile((String)path).isEmpty();
        };
    }

    public void validateColumns(List<HiveColumnHandle> handles) {
        if (this == AVRO) {
            for (HiveColumnHandle handle : handles) {
                if (handle.isPartitionKey()) continue;
                HiveStorageFormat.validateAvroType(handle.getHiveType().getTypeInfo(), handle.getName());
            }
        }
    }

    private static void validateAvroType(TypeInfo type, String columnName) {
        if (type.getCategory() == Category.MAP) {
            TypeInfo keyType = HiveStorageFormat.mapTypeInfo(type).getMapKeyTypeInfo();
            if (keyType.getCategory() != Category.PRIMITIVE || HiveStorageFormat.primitiveTypeInfo(keyType).getPrimitiveCategory() != PrimitiveCategory.STRING) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' has a non-varchar map key, which is not supported by Avro", columnName));
            }
        } else if (type.getCategory() == Category.PRIMITIVE) {
            PrimitiveCategory primitive = HiveStorageFormat.primitiveTypeInfo(type).getPrimitiveCategory();
            if (primitive == PrimitiveCategory.BYTE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is tinyint, which is not supported by Avro. Use integer instead.", columnName));
            }
            if (primitive == PrimitiveCategory.SHORT) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is smallint, which is not supported by Avro. Use integer instead.", columnName));
            }
        }
    }

    private static PrimitiveTypeInfo primitiveTypeInfo(TypeInfo typeInfo) {
        return (PrimitiveTypeInfo)typeInfo;
    }

    private static MapTypeInfo mapTypeInfo(TypeInfo typeInfo) {
        return (MapTypeInfo)typeInfo;
    }

    public static Optional<HiveStorageFormat> getHiveStorageFormat(StorageFormat storageFormat) {
        return Optional.ofNullable(HIVE_STORAGE_FORMATS.get(new SerdeAndInputFormat(storageFormat.getSerde(), storageFormat.getInputFormat())));
    }

    static {
        HIVE_STORAGE_FORMATS = ImmutableMap.builder().putAll(Arrays.stream(HiveStorageFormat.values()).collect(Collectors.toMap(format -> new SerdeAndInputFormat(format.getSerde(), format.getInputFormat()), Functions.identity()))).put((Object)new SerdeAndInputFormat("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "parquet.hive.DeprecatedParquetInputFormat"), (Object)PARQUET).put((Object)new SerdeAndInputFormat("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "parquet.hive.MapredParquetInputFormat"), (Object)PARQUET).buildOrThrow();
    }

    private record SerdeAndInputFormat(String serde, String inputFormat) {
    }
}

