/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.log.Format;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.units.DataSize;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"log.legacy-implementation.enabled", "log.max-history", "log.max-size-in-bytes"})
public class LoggingConfiguration {
    private boolean consoleEnabled = true;
    private String logPath;
    private DataSize maxSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private DataSize maxTotalSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private RollingFileMessageOutput.CompressionType compression = RollingFileMessageOutput.CompressionType.GZIP;
    private int maxHistory = 30;
    private String levelsFile;
    private String logAnnotationFile;
    private Format format = Format.TEXT;

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    @Config(value="log.enable-console")
    public LoggingConfiguration setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @LegacyConfig(value={"log.output-file"})
    @Config(value="log.path")
    public LoggingConfiguration setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public DataSize getMaxSize() {
        return this.maxSize;
    }

    @Config(value="log.max-size")
    @ConfigDescription(value="Maximum size of each log file")
    public LoggingConfiguration setMaxSize(DataSize maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public DataSize getMaxTotalSize() {
        return this.maxTotalSize;
    }

    @Config(value="log.max-total-size")
    @ConfigDescription(value="Maximum size of all log files")
    public LoggingConfiguration setMaxTotalSize(DataSize maxTotalSize) {
        this.maxTotalSize = maxTotalSize;
        return this;
    }

    @NotNull
    public RollingFileMessageOutput.CompressionType getCompression() {
        return this.compression;
    }

    @Config(value="log.compression")
    @ConfigDescription(value="Compression type for log files")
    public LoggingConfiguration setCompression(RollingFileMessageOutput.CompressionType compression) {
        this.compression = compression;
        return this;
    }

    public String getLevelsFile() {
        return this.levelsFile;
    }

    @Config(value="log.levels-file")
    public LoggingConfiguration setLevelsFile(String levelsFile) {
        this.levelsFile = levelsFile;
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    @Config(value="log.format")
    public LoggingConfiguration setFormat(Format format) {
        this.format = format;
        return this;
    }

    @FileExists
    public String getLogAnnotationFile() {
        return this.logAnnotationFile;
    }

    @Config(value="node.annotation-file")
    @LegacyConfig(value={"log.annotation-file"})
    public LoggingConfiguration setLogAnnotationFile(String logAnnotationFile) {
        this.logAnnotationFile = logAnnotationFile;
        return this;
    }
}

