/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.drift.TException;
import io.airlift.drift.client.DriftClient;
import io.airlift.units.Duration;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.plugin.thrift.ThriftColumnHandle;
import io.trino.plugin.thrift.ThriftErrorCode;
import io.trino.plugin.thrift.ThriftHeaderProvider;
import io.trino.plugin.thrift.ThriftIndexHandle;
import io.trino.plugin.thrift.ThriftTableHandle;
import io.trino.plugin.thrift.ThriftTableMetadata;
import io.trino.plugin.thrift.annotations.ForMetadataRefresh;
import io.trino.plugin.thrift.api.TrinoThriftNullableSchemaName;
import io.trino.plugin.thrift.api.TrinoThriftNullableTableMetadata;
import io.trino.plugin.thrift.api.TrinoThriftSchemaTableName;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.api.TrinoThriftServiceException;
import io.trino.plugin.thrift.util.ThriftExceptions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ThriftMetadata
implements ConnectorMetadata {
    private static final Duration EXPIRE_AFTER_WRITE = new Duration(10.0, TimeUnit.MINUTES);
    private static final Duration REFRESH_AFTER_WRITE = new Duration(2.0, TimeUnit.MINUTES);
    private final DriftClient<TrinoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final TypeManager typeManager;
    private final NonEvictableLoadingCache<SchemaTableName, Optional<ThriftTableMetadata>> tableCache;

    @Inject
    public ThriftMetadata(DriftClient<TrinoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, TypeManager typeManager, @ForMetadataRefresh Executor metadataRefreshExecutor) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(EXPIRE_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS).refreshAfterWrite(REFRESH_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS), (CacheLoader)CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::getTableMetadataInternal), (Executor)metadataRefreshExecutor));
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        try {
            return ((TrinoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listSchemaNames();
        }
        catch (TException | TrinoThriftServiceException e) {
            throw ThriftExceptions.toTrinoException((Exception)e);
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return ((Optional)this.tableCache.getUnchecked((Object)tableName)).map(ThriftTableMetadata::getSchemaTableName).map(ThriftTableHandle::new).orElse(null);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ThriftTableHandle handle = (ThriftTableHandle)tableHandle;
        return this.getRequiredTableMetadata(new SchemaTableName(handle.getSchemaName(), handle.getTableName())).toConnectorTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        try {
            return (List)((TrinoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listTables(new TrinoThriftNullableSchemaName((String)schemaName.orElse(null))).stream().map(TrinoThriftSchemaTableName::toSchemaTableName).collect(ImmutableList.toImmutableList());
        }
        catch (TException | TrinoThriftServiceException e) {
            throw ThriftExceptions.toTrinoException((Exception)e);
        }
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return (Map)this.getTableMetadata(session, tableHandle).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ThriftColumnHandle::new));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((ThriftColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)this.listTables(session, prefix.getSchema()).stream().collect(ImmutableMap.toImmutableMap(Function.identity(), schemaTableName -> this.getRequiredTableMetadata((SchemaTableName)schemaTableName).getColumns()));
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ThriftTableHandle table = (ThriftTableHandle)tableHandle;
        ThriftTableMetadata tableMetadata = this.getRequiredTableMetadata(new SchemaTableName(table.getSchemaName(), table.getTableName()));
        if (tableMetadata.containsIndexableColumns(indexableColumns)) {
            return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)new ThriftIndexHandle(tableMetadata.getSchemaTableName(), tupleDomain, session), tupleDomain));
        }
        return Optional.empty();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        ThriftTableHandle handle = (ThriftTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new ThriftTableHandle(handle.getSchemaName(), handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, handle.getDesiredColumns());
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary(), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        ThriftTableHandle handle = (ThriftTableHandle)table;
        if (handle.getDesiredColumns().isPresent()) {
            return Optional.empty();
        }
        ImmutableSet.Builder desiredColumns = ImmutableSet.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            desiredColumns.add(column);
            assignmentList.add((Object)new Assignment(name, column, ((ThriftColumnHandle)column).getColumnType()));
        });
        handle = new ThriftTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getConstraint(), Optional.of(desiredColumns.build()));
        return Optional.of(new ProjectionApplicationResult((Object)handle, projections, (List)assignmentList.build(), false));
    }

    private ThriftTableMetadata getRequiredTableMetadata(SchemaTableName schemaTableName) {
        return (ThriftTableMetadata)((Optional)this.tableCache.getUnchecked((Object)schemaTableName)).orElseThrow(() -> new TableNotFoundException(schemaTableName));
    }

    private Optional<ThriftTableMetadata> getTableMetadataInternal(SchemaTableName schemaTableName) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        TrinoThriftNullableTableMetadata thriftTableMetadata = this.getTableMetadata(schemaTableName);
        if (thriftTableMetadata.getTableMetadata() == null) {
            return Optional.empty();
        }
        ThriftTableMetadata tableMetadata = new ThriftTableMetadata(thriftTableMetadata.getTableMetadata(), this.typeManager);
        if (!Objects.equals(schemaTableName, tableMetadata.getSchemaTableName())) {
            throw new TrinoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_INVALID_RESPONSE, "Requested and actual table names are different");
        }
        return Optional.of(tableMetadata);
    }

    private TrinoThriftNullableTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        TrinoThriftSchemaTableName name;
        try {
            name = new TrinoThriftSchemaTableName(schemaTableName);
        }
        catch (IllegalArgumentException e) {
            return new TrinoThriftNullableTableMetadata(null);
        }
        try {
            return ((TrinoThriftService)this.client.get()).getTableMetadata(name);
        }
        catch (TException | TrinoThriftServiceException e) {
            throw ThriftExceptions.toTrinoException((Exception)e);
        }
    }
}

