/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.drift.client.DriftClient;
import io.trino.plugin.thrift.ThriftColumnHandle;
import io.trino.plugin.thrift.ThriftConnectorStats;
import io.trino.plugin.thrift.ThriftIndexHandle;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.plugin.thrift.api.TrinoThriftNullableToken;
import io.trino.plugin.thrift.api.TrinoThriftPageResult;
import io.trino.plugin.thrift.api.TrinoThriftSchemaTableName;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.api.TrinoThriftSplit;
import io.trino.plugin.thrift.api.TrinoThriftSplitBatch;
import io.trino.plugin.thrift.api.TrinoThriftTupleDomain;
import io.trino.plugin.thrift.util.ThriftExceptions;
import io.trino.plugin.thrift.util.TupleDomainConversion;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class ThriftIndexPageSource
implements ConnectorPageSource {
    private static final int MAX_SPLIT_COUNT = 10000000;
    private final DriftClient<TrinoThriftService> client;
    private final Map<String, String> thriftHeaders;
    private final TrinoThriftSchemaTableName schemaTableName;
    private final List<String> lookupColumnNames;
    private final List<String> outputColumnNames;
    private final List<Type> outputColumnTypes;
    private final TrinoThriftTupleDomain outputConstraint;
    private final TrinoThriftPageResult keys;
    private final long maxBytesPerResponse;
    private final int lookupRequestsConcurrency;
    private final AtomicLong readTimeNanos = new AtomicLong(0L);
    private long completedBytes;
    private CompletableFuture<?> statusFuture;
    private ListenableFuture<TrinoThriftSplitBatch> splitFuture;
    private ListenableFuture<TrinoThriftPageResult> dataSignalFuture;
    private final List<TrinoThriftSplit> splits = new ArrayList<TrinoThriftSplit>();
    private final Queue<ListenableFuture<TrinoThriftPageResult>> dataRequests = new LinkedList<ListenableFuture<TrinoThriftPageResult>>();
    private final Map<ListenableFuture<TrinoThriftPageResult>, RunningSplitContext> contexts;
    private final ThriftConnectorStats stats;
    private int splitIndex;
    private boolean haveSplits;
    private boolean finished;

    public ThriftIndexPageSource(DriftClient<TrinoThriftService> client, Map<String, String> thriftHeaders, ThriftConnectorStats stats, ThriftIndexHandle indexHandle, List<ColumnHandle> lookupColumns, List<ColumnHandle> outputColumns, RecordSet keys, long maxBytesPerResponse, int lookupRequestsConcurrency) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaders = Objects.requireNonNull(thriftHeaders, "thriftHeaders is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.schemaTableName = new TrinoThriftSchemaTableName(indexHandle.getSchemaTableName());
        this.outputConstraint = TupleDomainConversion.tupleDomainToThriftTupleDomain(indexHandle.getTupleDomain());
        Objects.requireNonNull(lookupColumns, "lookupColumns is null");
        this.lookupColumnNames = (List)lookupColumns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableList.toImmutableList());
        Objects.requireNonNull(outputColumns, "outputColumns is null");
        ImmutableList.Builder outputColumnNames = ImmutableList.builder();
        ImmutableList.Builder outputColumnTypes = ImmutableList.builder();
        for (ColumnHandle columnHandle : outputColumns) {
            ThriftColumnHandle thriftColumnHandle = (ThriftColumnHandle)columnHandle;
            outputColumnNames.add((Object)thriftColumnHandle.getColumnName());
            outputColumnTypes.add((Object)thriftColumnHandle.getColumnType());
        }
        this.outputColumnNames = outputColumnNames.build();
        this.outputColumnTypes = outputColumnTypes.build();
        this.keys = TrinoThriftPageResult.fromRecordSet((RecordSet)Objects.requireNonNull(keys, "keys is null"));
        Preconditions.checkArgument((maxBytesPerResponse > 0L ? 1 : 0) != 0, (Object)"maxBytesPerResponse is zero or negative");
        this.maxBytesPerResponse = maxBytesPerResponse;
        Preconditions.checkArgument((lookupRequestsConcurrency >= 1 ? 1 : 0) != 0, (Object)"lookupRequestsConcurrency is less than one");
        this.lookupRequestsConcurrency = lookupRequestsConcurrency;
        this.contexts = new HashMap<ListenableFuture<TrinoThriftPageResult>, RunningSplitContext>(lookupRequestsConcurrency);
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public CompletableFuture<?> isBlocked() {
        return this.statusFuture == null ? NOT_BLOCKED : this.statusFuture;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        if (!this.loadAllSplits()) {
            return null;
        }
        if (this.dataSignalFuture == null) {
            Preconditions.checkState((this.contexts.isEmpty() && this.dataRequests.isEmpty() ? 1 : 0) != 0, (Object)"some splits are already started");
            if (this.splits.isEmpty()) {
                this.finished = true;
                return null;
            }
            for (int i = 0; i < Math.min(this.lookupRequestsConcurrency, this.splits.size()); ++i) {
                this.startDataFetchForNextSplit();
            }
            this.updateSignalAndStatusFutures();
        }
        if (!this.dataSignalFuture.isDone()) {
            return null;
        }
        ListenableFuture<TrinoThriftPageResult> resultFuture = this.getAndRemoveNextCompletedRequest();
        RunningSplitContext resultContext = this.contexts.remove(resultFuture);
        Preconditions.checkState((resultContext != null ? 1 : 0) != 0, (Object)"no associated context for the request");
        TrinoThriftPageResult pageResult = (TrinoThriftPageResult)MoreFutures.getFutureValue(resultFuture);
        Page page = pageResult.toPage(this.outputColumnTypes);
        if (page != null) {
            long pageSize = page.getSizeInBytes();
            this.completedBytes += pageSize;
            this.stats.addIndexPageSize(pageSize);
        } else {
            this.stats.addIndexPageSize(0L);
        }
        if (pageResult.getNextToken() != null) {
            this.sendDataRequest(resultContext, pageResult.getNextToken());
            this.updateSignalAndStatusFutures();
            return page;
        }
        if (this.splitIndex < this.splits.size()) {
            this.startDataFetchForNextSplit();
            this.updateSignalAndStatusFutures();
        } else if (!this.dataRequests.isEmpty()) {
            this.updateSignalAndStatusFutures();
        } else {
            this.dataSignalFuture = null;
            this.statusFuture = null;
            this.finished = true;
        }
        return page;
    }

    private boolean loadAllSplits() {
        if (this.haveSplits) {
            return true;
        }
        if (this.splitFuture == null) {
            this.splitFuture = this.sendSplitRequest(null);
            this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.splitFuture));
        }
        if (!this.splitFuture.isDone()) {
            return false;
        }
        TrinoThriftSplitBatch batch = (TrinoThriftSplitBatch)MoreFutures.getFutureValue(this.splitFuture);
        this.splits.addAll(batch.getSplits());
        if (batch.getNextToken() != null) {
            this.splitFuture = this.sendSplitRequest(batch.getNextToken());
            this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.splitFuture));
            return false;
        }
        this.splitFuture = null;
        this.statusFuture = null;
        this.haveSplits = true;
        return true;
    }

    private void updateSignalAndStatusFutures() {
        this.dataSignalFuture = MoreFutures.whenAnyComplete(this.dataRequests);
        this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.dataSignalFuture));
    }

    private void startDataFetchForNextSplit() {
        TrinoThriftSplit split = this.splits.get(this.splitIndex);
        ++this.splitIndex;
        RunningSplitContext context = new RunningSplitContext(this.openClient(split), split);
        this.sendDataRequest(context, null);
    }

    private ListenableFuture<TrinoThriftSplitBatch> sendSplitRequest(@Nullable TrinoThriftId nextToken) {
        long start = System.nanoTime();
        ListenableFuture future = ((TrinoThriftService)this.client.get(this.thriftHeaders)).getIndexSplits(this.schemaTableName, this.lookupColumnNames, this.outputColumnNames, this.keys, this.outputConstraint, 10000000, new TrinoThriftNullableToken(nextToken));
        future = ThriftExceptions.catchingThriftException(future);
        future.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        return future;
    }

    private void sendDataRequest(RunningSplitContext context, @Nullable TrinoThriftId nextToken) {
        long start = System.nanoTime();
        ListenableFuture future = context.getClient().getRows(context.getSplit().getSplitId(), this.outputColumnNames, this.maxBytesPerResponse, new TrinoThriftNullableToken(nextToken));
        future = ThriftExceptions.catchingThriftException(future);
        future.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        this.dataRequests.add(future);
        this.contexts.put(future, context);
    }

    private TrinoThriftService openClient(TrinoThriftSplit split) {
        if (split.getHosts().isEmpty()) {
            return (TrinoThriftService)this.client.get(this.thriftHeaders);
        }
        String hosts = split.getHosts().stream().map(host -> host.toHostAddress().toString()).collect(Collectors.joining(","));
        return (TrinoThriftService)this.client.get(Optional.of(hosts), this.thriftHeaders);
    }

    public void close() {
        ThriftIndexPageSource.cancelQuietly(this.splitFuture);
        this.dataRequests.forEach(ThriftIndexPageSource::cancelQuietly);
    }

    private ListenableFuture<TrinoThriftPageResult> getAndRemoveNextCompletedRequest() {
        Iterator iterator = this.dataRequests.iterator();
        while (iterator.hasNext()) {
            ListenableFuture future = (ListenableFuture)iterator.next();
            if (!future.isDone()) continue;
            iterator.remove();
            return future;
        }
        throw new IllegalStateException("No completed splits in the queue");
    }

    private static void cancelQuietly(Future<?> future) {
        if (future != null) {
            future.cancel(true);
        }
    }

    private static final class RunningSplitContext {
        private final TrinoThriftService client;
        private final TrinoThriftSplit split;

        public RunningSplitContext(TrinoThriftService client, TrinoThriftSplit split) {
            this.client = client;
            this.split = split;
        }

        public TrinoThriftService getClient() {
            return this.client;
        }

        public TrinoThriftSplit getSplit() {
            return this.split;
        }
    }
}

