/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTSessionCatalog;

public class RESTCatalog
implements Catalog,
SupportsNamespaces,
Configurable<Object>,
Closeable {
    private final RESTSessionCatalog sessionCatalog;
    private final Catalog delegate;
    private final SupportsNamespaces nsDelegate;

    public RESTCatalog() {
        this(SessionCatalog.SessionContext.createEmpty(), config -> HTTPClient.builder(config).uri((String)config.get("uri")).build());
    }

    public RESTCatalog(Function<Map<String, String>, RESTClient> clientBuilder) {
        this(SessionCatalog.SessionContext.createEmpty(), clientBuilder);
    }

    public RESTCatalog(SessionCatalog.SessionContext context, Function<Map<String, String>, RESTClient> clientBuilder) {
        this.sessionCatalog = new RESTSessionCatalog(clientBuilder, null);
        this.delegate = this.sessionCatalog.asCatalog(context);
        this.nsDelegate = (SupportsNamespaces)this.delegate;
    }

    public void initialize(String name, Map<String, String> props) {
        Preconditions.checkArgument((props != null ? 1 : 0) != 0, (Object)"Invalid configuration: null");
        this.sessionCatalog.initialize(name, props);
    }

    public String name() {
        return this.sessionCatalog.name();
    }

    public Map<String, String> properties() {
        return this.sessionCatalog.properties();
    }

    public List<TableIdentifier> listTables(Namespace ns) {
        return this.delegate.listTables(ns);
    }

    public boolean tableExists(TableIdentifier ident) {
        return this.delegate.tableExists(ident);
    }

    public Table loadTable(TableIdentifier ident) {
        return this.delegate.loadTable(ident);
    }

    public void invalidateTable(TableIdentifier ident) {
        this.delegate.invalidateTable(ident);
    }

    public Catalog.TableBuilder buildTable(TableIdentifier ident, Schema schema) {
        return this.delegate.buildTable(ident, schema);
    }

    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props) {
        return this.delegate.createTable(ident, schema, spec, location, props);
    }

    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props) {
        return this.delegate.createTable(ident, schema, spec, props);
    }

    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        return this.delegate.createTable(ident, schema, spec);
    }

    public Table createTable(TableIdentifier identifier, Schema schema) {
        return this.delegate.createTable(identifier, schema);
    }

    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec, location, props);
    }

    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec, props);
    }

    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec);
    }

    public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema) {
        return this.delegate.newCreateTableTransaction(identifier, schema);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, location, props, orCreate);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, props, orCreate);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, orCreate);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, orCreate);
    }

    public boolean dropTable(TableIdentifier ident) {
        return this.delegate.dropTable(ident);
    }

    public boolean dropTable(TableIdentifier ident, boolean purge) {
        return this.delegate.dropTable(ident, purge);
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.delegate.renameTable(from, to);
    }

    public Table registerTable(TableIdentifier ident, String metadataFileLocation) {
        return this.delegate.registerTable(ident, metadataFileLocation);
    }

    public void createNamespace(Namespace ns, Map<String, String> props) {
        this.nsDelegate.createNamespace(ns, props);
    }

    public List<Namespace> listNamespaces(Namespace ns) throws NoSuchNamespaceException {
        return this.nsDelegate.listNamespaces(ns);
    }

    public Map<String, String> loadNamespaceMetadata(Namespace ns) throws NoSuchNamespaceException {
        return this.nsDelegate.loadNamespaceMetadata(ns);
    }

    public boolean dropNamespace(Namespace ns) throws NamespaceNotEmptyException {
        return this.nsDelegate.dropNamespace(ns);
    }

    public boolean setProperties(Namespace ns, Map<String, String> props) throws NoSuchNamespaceException {
        return this.nsDelegate.setProperties(ns, props);
    }

    public boolean removeProperties(Namespace ns, Set<String> props) throws NoSuchNamespaceException {
        return this.nsDelegate.removeProperties(ns, props);
    }

    @Override
    public void setConf(Object conf) {
        this.sessionCatalog.setConf(conf);
    }

    @Override
    public void close() throws IOException {
        this.sessionCatalog.close();
    }
}

