/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableSupplier;

public class TableMetadata
implements Serializable {
    static final long INITIAL_SEQUENCE_NUMBER = 0L;
    static final long INVALID_SEQUENCE_NUMBER = -1L;
    static final int DEFAULT_TABLE_FORMAT_VERSION = 1;
    static final int SUPPORTED_TABLE_FORMAT_VERSION = 2;
    static final int INITIAL_SPEC_ID = 0;
    static final int INITIAL_SORT_ORDER_ID = 1;
    static final int INITIAL_SCHEMA_ID = 0;
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final String metadataFileLocation;
    private final int formatVersion;
    private final String uuid;
    private final String location;
    private final long lastSequenceNumber;
    private final long lastUpdatedMillis;
    private final int lastColumnId;
    private final int currentSchemaId;
    private final List<Schema> schemas;
    private final int defaultSpecId;
    private final List<PartitionSpec> specs;
    private final int lastAssignedPartitionId;
    private final int defaultSortOrderId;
    private final List<SortOrder> sortOrders;
    private final Map<String, String> properties;
    private final long currentSnapshotId;
    private final Map<Integer, Schema> schemasById;
    private final Map<Integer, PartitionSpec> specsById;
    private final Map<Integer, SortOrder> sortOrdersById;
    private final List<HistoryEntry> snapshotLog;
    private final List<MetadataLogEntry> previousFiles;
    private final List<StatisticsFile> statisticsFiles;
    private final List<MetadataUpdate> changes;
    private SerializableSupplier<List<Snapshot>> snapshotsSupplier;
    private volatile List<Snapshot> snapshots;
    private volatile Map<Long, Snapshot> snapshotsById;
    private volatile Map<String, SnapshotRef> refs;
    private volatile boolean snapshotsLoaded;

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties) {
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        SortOrder sortOrder = SortOrder.unsorted();
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    private static Map<String, String> unreservedProperties(Map<String, String> rawProperties) {
        return rawProperties.entrySet().stream().filter(e -> !TableProperties.RESERVED_PROPERTIES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties, int formatVersion) {
        Preconditions.checkArgument((boolean)properties.keySet().stream().noneMatch(TableProperties.RESERVED_PROPERTIES::contains), (String)"Table properties should not contain reserved properties, but got %s", properties);
        AtomicInteger lastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds((int)0, (Schema)schema, lastColumnId::incrementAndGet);
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)freshSchema).withSpecId(0);
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            specBuilder.add(freshSchema.findField(sourceName).fieldId(), field.name(), field.transform());
        }
        PartitionSpec freshSpec = specBuilder.build();
        int freshSortOrderId = sortOrder.isUnsorted() ? sortOrder.orderId() : 1;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, sortOrder);
        MetricsConfig.fromProperties(properties).validateReferencedColumns(schema);
        return new Builder().upgradeFormatVersion(formatVersion).setCurrentSchema(freshSchema, lastColumnId.get()).setDefaultPartitionSpec(freshSpec).setDefaultSortOrder(freshSortOrder).setLocation(location).setProperties(properties).build();
    }

    TableMetadata(String metadataFileLocation, int formatVersion, String uuid, String location, long lastSequenceNumber, long lastUpdatedMillis, int lastColumnId, int currentSchemaId, List<Schema> schemas, int defaultSpecId, List<PartitionSpec> specs, int lastAssignedPartitionId, int defaultSortOrderId, List<SortOrder> sortOrders, Map<String, String> properties, long currentSnapshotId, List<Snapshot> snapshots, SerializableSupplier<List<Snapshot>> snapshotsSupplier, List<HistoryEntry> snapshotLog, List<MetadataLogEntry> previousFiles, Map<String, SnapshotRef> refs, List<StatisticsFile> statisticsFiles, List<MetadataUpdate> changes) {
        Preconditions.checkArgument((specs != null && !specs.isEmpty() ? 1 : 0) != 0, (Object)"Partition specs cannot be null or empty");
        Preconditions.checkArgument((sortOrders != null && !sortOrders.isEmpty() ? 1 : 0) != 0, (Object)"Sort orders cannot be null or empty");
        Preconditions.checkArgument((formatVersion <= 2 ? 1 : 0) != 0, (String)"Unsupported format version: v%s", (int)formatVersion);
        Preconditions.checkArgument((formatVersion == 1 || uuid != null ? 1 : 0) != 0, (String)"UUID is required in format v%s", (int)formatVersion);
        Preconditions.checkArgument((formatVersion > 1 || lastSequenceNumber == 0L ? 1 : 0) != 0, (String)"Sequence number must be 0 in v1: %s", (long)lastSequenceNumber);
        Preconditions.checkArgument((metadataFileLocation == null || changes.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create TableMetadata with a metadata location and changes");
        this.metadataFileLocation = metadataFileLocation;
        this.formatVersion = formatVersion;
        this.uuid = uuid;
        this.location = location != null ? LocationUtil.stripTrailingSlash(location) : null;
        this.lastSequenceNumber = lastSequenceNumber;
        this.lastUpdatedMillis = lastUpdatedMillis;
        this.lastColumnId = lastColumnId;
        this.currentSchemaId = currentSchemaId;
        this.schemas = schemas;
        this.specs = specs;
        this.defaultSpecId = defaultSpecId;
        this.lastAssignedPartitionId = lastAssignedPartitionId;
        this.defaultSortOrderId = defaultSortOrderId;
        this.sortOrders = sortOrders;
        this.properties = properties;
        this.currentSnapshotId = currentSnapshotId;
        this.snapshots = snapshots;
        this.snapshotsSupplier = snapshotsSupplier;
        this.snapshotsLoaded = snapshotsSupplier == null;
        this.snapshotLog = snapshotLog;
        this.previousFiles = previousFiles;
        this.changes = changes;
        this.snapshotsById = TableMetadata.indexAndValidateSnapshots(snapshots, lastSequenceNumber);
        this.schemasById = this.indexSchemas();
        this.specsById = TableMetadata.indexSpecs(specs);
        this.sortOrdersById = TableMetadata.indexSortOrders(sortOrders);
        this.refs = TableMetadata.validateRefs(currentSnapshotId, refs, this.snapshotsById);
        this.statisticsFiles = ImmutableList.copyOf(statisticsFiles);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : snapshotLog) {
            if (last != null) {
                Preconditions.checkArgument((logEntry.timestampMillis() - last.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (Object)"[BUG] Expected sorted snapshot log entries.");
            }
            last = logEntry;
        }
        if (last != null) {
            Preconditions.checkArgument((lastUpdatedMillis - last.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (String)"Invalid update timestamp %s: before last snapshot log entry at %s", (long)lastUpdatedMillis, (long)last.timestampMillis());
        }
        MetadataLogEntry previous = null;
        for (MetadataLogEntry metadataEntry : previousFiles) {
            if (previous != null) {
                Preconditions.checkArgument((metadataEntry.timestampMillis() - previous.timestampMillis() >= -ONE_MINUTE ? 1 : 0) != 0, (Object)"[BUG] Expected sorted previous metadata log entries.");
            }
            previous = metadataEntry;
        }
        if (previous != null) {
            Preconditions.checkArgument((lastUpdatedMillis - previous.timestampMillis >= -ONE_MINUTE ? 1 : 0) != 0, (String)"Invalid update timestamp %s: before the latest metadata log entry timestamp %s", (long)lastUpdatedMillis, (long)previous.timestampMillis);
        }
        this.validateCurrentSnapshot();
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String metadataFileLocation() {
        return this.metadataFileLocation;
    }

    public String uuid() {
        return this.uuid;
    }

    public long lastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long nextSequenceNumber() {
        return this.formatVersion > 1 ? this.lastSequenceNumber + 1L : 0L;
    }

    public long lastUpdatedMillis() {
        return this.lastUpdatedMillis;
    }

    public int lastColumnId() {
        return this.lastColumnId;
    }

    public Schema schema() {
        return this.schemasById.get(this.currentSchemaId);
    }

    public List<Schema> schemas() {
        return this.schemas;
    }

    public Map<Integer, Schema> schemasById() {
        return this.schemasById;
    }

    public int currentSchemaId() {
        return this.currentSchemaId;
    }

    public PartitionSpec spec() {
        return this.specsById.get(this.defaultSpecId);
    }

    public PartitionSpec spec(int id) {
        return this.specsById.get(id);
    }

    public List<PartitionSpec> specs() {
        return this.specs;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    public int lastAssignedPartitionId() {
        return this.lastAssignedPartitionId;
    }

    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    public int defaultSortOrderId() {
        return this.defaultSortOrderId;
    }

    public SortOrder sortOrder() {
        return this.sortOrdersById.get(this.defaultSortOrderId);
    }

    public List<SortOrder> sortOrders() {
        return this.sortOrders;
    }

    public Map<Integer, SortOrder> sortOrdersById() {
        return this.sortOrdersById;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean propertyAsBoolean(String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(this.properties, property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(this.properties, property, defaultValue);
    }

    public long propertyAsLong(String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(this.properties, property, defaultValue);
    }

    public Snapshot snapshot(long snapshotId) {
        if (!this.snapshotsById.containsKey(snapshotId)) {
            this.ensureSnapshotsLoaded();
        }
        return this.snapshotsById.get(snapshotId);
    }

    public Snapshot currentSnapshot() {
        return this.snapshotsById.get(this.currentSnapshotId);
    }

    public List<Snapshot> snapshots() {
        this.ensureSnapshotsLoaded();
        return this.snapshots;
    }

    private synchronized void ensureSnapshotsLoaded() {
        if (!this.snapshotsLoaded) {
            ArrayList loadedSnapshots = Lists.newArrayList((Iterable)((Iterable)this.snapshotsSupplier.get()));
            loadedSnapshots.removeIf(s -> s.sequenceNumber() > this.lastSequenceNumber);
            if (this.formatVersion == 1) {
                loadedSnapshots.removeIf(s -> s.timestampMillis() > this.currentSnapshot().timestampMillis());
            }
            this.snapshots = ImmutableList.copyOf((Collection)loadedSnapshots);
            this.snapshotsById = TableMetadata.indexAndValidateSnapshots(this.snapshots, this.lastSequenceNumber);
            this.validateCurrentSnapshot();
            this.refs = TableMetadata.validateRefs(this.currentSnapshotId, this.refs, this.snapshotsById);
            this.snapshotsLoaded = true;
            this.snapshotsSupplier = null;
        }
    }

    public SnapshotRef ref(String name) {
        return this.refs.get(name);
    }

    public Map<String, SnapshotRef> refs() {
        return this.refs;
    }

    public List<StatisticsFile> statisticsFiles() {
        return this.statisticsFiles;
    }

    public List<HistoryEntry> snapshotLog() {
        return this.snapshotLog;
    }

    public List<MetadataLogEntry> previousFiles() {
        return this.previousFiles;
    }

    public List<MetadataUpdate> changes() {
        return this.changes;
    }

    public TableMetadata withUUID() {
        return new Builder(this).assignUUID().build();
    }

    public TableMetadata updateSchema(Schema newSchema, int newLastColumnId) {
        return new Builder(this).setCurrentSchema(newSchema, newLastColumnId).build();
    }

    public TableMetadata updatePartitionSpec(PartitionSpec newPartitionSpec) {
        return new Builder(this).setDefaultPartitionSpec(newPartitionSpec).build();
    }

    public TableMetadata replaceSortOrder(SortOrder newOrder) {
        return new Builder(this).setDefaultSortOrder(newOrder).build();
    }

    public TableMetadata removeSnapshotsIf(Predicate<Snapshot> removeIf) {
        List<Snapshot> toRemove = this.snapshots().stream().filter(removeIf).collect(Collectors.toList());
        return new Builder(this).removeSnapshots(toRemove).build();
    }

    public TableMetadata replaceProperties(Map<String, String> rawProperties) {
        ValidationException.check((rawProperties != null ? 1 : 0) != 0, (String)"Cannot set properties to null", (Object[])new Object[0]);
        Map<String, String> newProperties = TableMetadata.unreservedProperties(rawProperties);
        HashSet removed = Sets.newHashSet(this.properties.keySet());
        HashMap updated = Maps.newHashMap();
        for (Map.Entry<String, String> entry : newProperties.entrySet()) {
            removed.remove(entry.getKey());
            String current = this.properties.get(entry.getKey());
            if (current != null && current.equals(entry.getValue())) continue;
            updated.put(entry.getKey(), entry.getValue());
        }
        int newFormatVersion = PropertyUtil.propertyAsInt(rawProperties, "format-version", this.formatVersion);
        return new Builder(this).setProperties(updated).removeProperties(removed).upgradeFormatVersion(newFormatVersion).build();
    }

    private void validateCurrentSnapshot() {
        Preconditions.checkArgument((this.currentSnapshotId < 0L || this.snapshotsById.containsKey(this.currentSnapshotId) ? 1 : 0) != 0, (Object)"Invalid table metadata: Cannot find current version");
    }

    private PartitionSpec reassignPartitionIds(PartitionSpec partitionSpec, TypeUtil.NextID nextID) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)partitionSpec.schema()).withSpecId(partitionSpec.specId());
        if (this.formatVersion > 1) {
            Map<Pair, Integer> transformToFieldId = this.specs.stream().flatMap(spec -> spec.fields().stream()).collect(Collectors.toMap(field -> Pair.of(field.sourceId(), field.transform().toString()), PartitionField::fieldId, Math::max));
            for (PartitionField field2 : partitionSpec.fields()) {
                int partitionFieldId = transformToFieldId.computeIfAbsent(Pair.of(field2.sourceId(), field2.transform().toString()), k -> nextID.get());
                specBuilder.add(field2.sourceId(), partitionFieldId, field2.name(), field2.transform());
            }
        } else {
            LinkedHashMap newFields = Maps.newLinkedHashMap();
            for (PartitionField newField : partitionSpec.fields()) {
                newFields.put(Pair.of(newField.sourceId(), newField.transform().toString()), newField);
            }
            List newFieldNames = newFields.values().stream().map(PartitionField::name).collect(Collectors.toList());
            for (PartitionField field3 : this.spec().fields()) {
                PartitionField newField = (PartitionField)newFields.remove(Pair.of(field3.sourceId(), field3.transform().toString()));
                if (newField != null) {
                    specBuilder.add(newField.sourceId(), field3.fieldId(), newField.name(), newField.transform());
                    continue;
                }
                String voidName = newFieldNames.contains(field3.name()) ? field3.name() + "_" + field3.fieldId() : field3.name();
                specBuilder.add(field3.sourceId(), field3.fieldId(), voidName, Transforms.alwaysNull());
            }
            for (PartitionField newField : newFields.values()) {
                specBuilder.add(newField.sourceId(), nextID.get(), newField.name(), newField.transform());
            }
        }
        return specBuilder.build();
    }

    public TableMetadata buildReplacement(Schema updatedSchema, PartitionSpec updatedPartitionSpec, SortOrder updatedSortOrder, String newLocation, Map<String, String> updatedProperties) {
        ValidationException.check((this.formatVersion > 1 || PartitionSpec.hasSequentialIds((PartitionSpec)updatedPartitionSpec) ? 1 : 0) != 0, (String)"Spec does not use sequential IDs that are required in v1: %s", (Object[])new Object[]{updatedPartitionSpec});
        AtomicInteger newLastColumnId = new AtomicInteger(this.lastColumnId);
        Schema freshSchema = TypeUtil.assignFreshIds((Schema)updatedSchema, (Schema)this.schema(), newLastColumnId::incrementAndGet);
        PartitionSpec freshSpec = this.reassignPartitionIds(TableMetadata.freshSpec(0, freshSchema, updatedPartitionSpec), new AtomicInteger(this.lastAssignedPartitionId)::incrementAndGet);
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(1, freshSchema, updatedSortOrder);
        int newFormatVersion = PropertyUtil.propertyAsInt(updatedProperties, "format-version", this.formatVersion);
        return new Builder(this).upgradeFormatVersion(newFormatVersion).removeRef("main").setCurrentSchema(freshSchema, newLastColumnId.get()).setDefaultPartitionSpec(freshSpec).setDefaultSortOrder(freshSortOrder).setLocation(newLocation).setProperties(TableMetadata.unreservedProperties(updatedProperties)).build();
    }

    public TableMetadata updateLocation(String newLocation) {
        return new Builder(this).setLocation(newLocation).build();
    }

    public TableMetadata upgradeToFormatVersion(int newFormatVersion) {
        return new Builder(this).upgradeFormatVersion(newFormatVersion).build();
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.fieldId(), field.name(), field.transform());
        }
        return specBuilder.buildUnchecked();
    }

    private static SortOrder updateSortOrderSchema(Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema).withOrderId(sortOrder.orderId());
        for (SortField field : sortOrder.fields()) {
            builder.addSortField(field.transform(), field.sourceId(), field.direction(), field.nullOrder());
        }
        return builder.buildUnchecked();
    }

    private static PartitionSpec freshSpec(int specId, Schema schema, PartitionSpec partitionSpec) {
        UnboundPartitionSpec.Builder specBuilder = UnboundPartitionSpec.builder().withSpecId(specId);
        for (PartitionField field : partitionSpec.fields()) {
            String sourceName = partitionSpec.schema().findColumnName(field.sourceId());
            int fieldId = sourceName != null ? schema.findField(sourceName).fieldId() : field.sourceId();
            specBuilder.addField(field.transform().toString(), fieldId, field.fieldId(), field.name());
        }
        return specBuilder.build().bind(schema);
    }

    private static SortOrder freshSortOrder(int orderId, Schema schema, SortOrder sortOrder) {
        UnboundSortOrder.Builder builder = UnboundSortOrder.builder();
        if (sortOrder.isSorted()) {
            builder.withOrderId(orderId);
        }
        for (SortField field : sortOrder.fields()) {
            String sourceName = sortOrder.schema().findColumnName(field.sourceId());
            int newSourceId = schema.findField(sourceName).fieldId();
            builder.addSortField(field.transform().toString(), newSourceId, field.direction(), field.nullOrder());
        }
        return builder.build().bind(schema);
    }

    private static Map<Long, Snapshot> indexAndValidateSnapshots(List<Snapshot> snapshots, long lastSequenceNumber) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Snapshot snap : snapshots) {
            ValidationException.check((snap.sequenceNumber() <= lastSequenceNumber ? 1 : 0) != 0, (String)"Invalid snapshot with sequence number %s greater than last sequence number %s", (Object[])new Object[]{snap.sequenceNumber(), lastSequenceNumber});
            builder.put((Object)snap.snapshotId(), (Object)snap);
        }
        return builder.build();
    }

    private Map<Integer, Schema> indexSchemas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Schema schema : this.schemas) {
            builder.put((Object)schema.schemaId(), (Object)schema);
        }
        return builder.build();
    }

    private static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put((Object)spec.specId(), (Object)spec);
        }
        return builder.build();
    }

    private static Map<Integer, SortOrder> indexSortOrders(List<SortOrder> sortOrders) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SortOrder sortOrder : sortOrders) {
            builder.put((Object)sortOrder.orderId(), (Object)sortOrder);
        }
        return builder.build();
    }

    private static Map<String, SnapshotRef> validateRefs(Long currentSnapshotId, Map<String, SnapshotRef> inputRefs, Map<Long, Snapshot> snapshotsById) {
        for (SnapshotRef ref : inputRefs.values()) {
            Preconditions.checkArgument((boolean)snapshotsById.containsKey(ref.snapshotId()), (String)"Snapshot for reference %s does not exist in the existing snapshots list", (Object)ref);
        }
        SnapshotRef main = inputRefs.get("main");
        if (currentSnapshotId != -1L) {
            Preconditions.checkArgument((main == null || currentSnapshotId.longValue() == main.snapshotId() ? 1 : 0) != 0, (String)"Current snapshot ID does not match main branch (%s != %s)", (Object)currentSnapshotId, main != null ? Long.valueOf(main.snapshotId()) : null);
        } else {
            Preconditions.checkArgument((main == null ? 1 : 0) != 0, (String)"Current snapshot is not set, but main branch exists: %s", (Object)main);
        }
        return inputRefs;
    }

    public static Builder buildFrom(TableMetadata base) {
        return new Builder(base);
    }

    public static Builder buildFromEmpty() {
        return new Builder();
    }

    public static class Builder {
        private static final int LAST_ADDED = -1;
        private final TableMetadata base;
        private String metadataLocation;
        private int formatVersion;
        private String uuid;
        private Long lastUpdatedMillis;
        private String location;
        private long lastSequenceNumber;
        private int lastColumnId;
        private int currentSchemaId;
        private final List<Schema> schemas;
        private int defaultSpecId;
        private List<PartitionSpec> specs;
        private int lastAssignedPartitionId;
        private int defaultSortOrderId;
        private List<SortOrder> sortOrders;
        private final Map<String, String> properties;
        private long currentSnapshotId;
        private List<Snapshot> snapshots;
        private SerializableSupplier<List<Snapshot>> snapshotsSupplier;
        private final Map<String, SnapshotRef> refs;
        private final Map<Long, List<StatisticsFile>> statisticsFiles;
        private final List<MetadataUpdate> changes;
        private final int startingChangeCount;
        private boolean discardChanges = false;
        private Integer lastAddedSchemaId = null;
        private Integer lastAddedSpecId = null;
        private Integer lastAddedOrderId = null;
        private final List<HistoryEntry> snapshotLog;
        private String previousFileLocation;
        private final List<MetadataLogEntry> previousFiles;
        private final Map<Long, Snapshot> snapshotsById;
        private final Map<Integer, Schema> schemasById;
        private final Map<Integer, PartitionSpec> specsById;
        private final Map<Integer, SortOrder> sortOrdersById;

        private Builder() {
            this.base = null;
            this.formatVersion = 1;
            this.lastSequenceNumber = 0L;
            this.uuid = UUID.randomUUID().toString();
            this.schemas = Lists.newArrayList();
            this.specs = Lists.newArrayList();
            this.sortOrders = Lists.newArrayList();
            this.properties = Maps.newHashMap();
            this.snapshots = Lists.newArrayList();
            this.currentSnapshotId = -1L;
            this.changes = Lists.newArrayList();
            this.startingChangeCount = 0;
            this.snapshotLog = Lists.newArrayList();
            this.previousFiles = Lists.newArrayList();
            this.refs = Maps.newHashMap();
            this.statisticsFiles = Maps.newHashMap();
            this.snapshotsById = Maps.newHashMap();
            this.schemasById = Maps.newHashMap();
            this.specsById = Maps.newHashMap();
            this.sortOrdersById = Maps.newHashMap();
        }

        private Builder(TableMetadata base) {
            this.base = base;
            this.formatVersion = base.formatVersion;
            this.uuid = base.uuid;
            this.lastUpdatedMillis = null;
            this.location = base.location;
            this.lastSequenceNumber = base.lastSequenceNumber;
            this.lastColumnId = base.lastColumnId;
            this.currentSchemaId = base.currentSchemaId;
            this.schemas = Lists.newArrayList((Iterable)base.schemas);
            this.defaultSpecId = base.defaultSpecId;
            this.specs = Lists.newArrayList((Iterable)base.specs);
            this.lastAssignedPartitionId = base.lastAssignedPartitionId;
            this.defaultSortOrderId = base.defaultSortOrderId;
            this.sortOrders = Lists.newArrayList((Iterable)base.sortOrders);
            this.properties = Maps.newHashMap((Map)base.properties);
            this.currentSnapshotId = base.currentSnapshotId;
            this.snapshots = Lists.newArrayList(base.snapshots());
            this.changes = Lists.newArrayList((Iterable)base.changes);
            this.startingChangeCount = this.changes.size();
            this.snapshotLog = Lists.newArrayList((Iterable)base.snapshotLog);
            this.previousFileLocation = base.metadataFileLocation;
            this.previousFiles = base.previousFiles;
            this.refs = Maps.newHashMap((Map)base.refs);
            this.statisticsFiles = base.statisticsFiles.stream().collect(Collectors.groupingBy(StatisticsFile::snapshotId));
            this.snapshotsById = Maps.newHashMap((Map)base.snapshotsById);
            this.schemasById = Maps.newHashMap((Map)base.schemasById);
            this.specsById = Maps.newHashMap((Map)base.specsById);
            this.sortOrdersById = Maps.newHashMap((Map)base.sortOrdersById);
        }

        public Builder withMetadataLocation(String newMetadataLocation) {
            this.metadataLocation = newMetadataLocation;
            return this;
        }

        public Builder assignUUID() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
                this.changes.add(new MetadataUpdate.AssignUUID(this.uuid));
            }
            return this;
        }

        public Builder assignUUID(String newUuid) {
            Preconditions.checkArgument((newUuid != null ? 1 : 0) != 0, (Object)"Cannot set uuid to null");
            if (!newUuid.equals(this.uuid)) {
                this.uuid = newUuid;
                this.changes.add(new MetadataUpdate.AssignUUID(this.uuid));
            }
            return this;
        }

        public Builder upgradeFormatVersion(int newFormatVersion) {
            Preconditions.checkArgument((newFormatVersion <= 2 ? 1 : 0) != 0, (String)"Cannot upgrade table to unsupported format version: v%s (supported: v%s)", (int)newFormatVersion, (int)2);
            Preconditions.checkArgument((newFormatVersion >= this.formatVersion ? 1 : 0) != 0, (String)"Cannot downgrade v%s table to v%s", (int)this.formatVersion, (int)newFormatVersion);
            if (newFormatVersion == this.formatVersion) {
                return this;
            }
            this.formatVersion = newFormatVersion;
            this.changes.add(new MetadataUpdate.UpgradeFormatVersion(newFormatVersion));
            return this;
        }

        public Builder setCurrentSchema(Schema newSchema, int newLastColumnId) {
            this.setCurrentSchema(this.addSchemaInternal(newSchema, newLastColumnId));
            return this;
        }

        public Builder setCurrentSchema(int schemaId) {
            if (schemaId == -1) {
                ValidationException.check((this.lastAddedSchemaId != null ? 1 : 0) != 0, (String)"Cannot set last added schema: no schema has been added", (Object[])new Object[0]);
                return this.setCurrentSchema(this.lastAddedSchemaId);
            }
            if (this.currentSchemaId == schemaId) {
                return this;
            }
            Schema schema = this.schemasById.get(schemaId);
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Cannot set current schema to unknown schema: %s", (int)schemaId);
            this.specs = Lists.newArrayList((Iterable)Iterables.transform(this.specs, spec -> TableMetadata.updateSpecSchema(schema, spec)));
            this.specsById.clear();
            this.specsById.putAll(TableMetadata.indexSpecs(this.specs));
            this.sortOrders = Lists.newArrayList((Iterable)Iterables.transform(this.sortOrders, order -> TableMetadata.updateSortOrderSchema(schema, order)));
            this.sortOrdersById.clear();
            this.sortOrdersById.putAll(TableMetadata.indexSortOrders(this.sortOrders));
            this.currentSchemaId = schemaId;
            if (this.lastAddedSchemaId != null && this.lastAddedSchemaId == schemaId) {
                this.changes.add(new MetadataUpdate.SetCurrentSchema(-1));
            } else {
                this.changes.add(new MetadataUpdate.SetCurrentSchema(schemaId));
            }
            return this;
        }

        public Builder addSchema(Schema schema, int newLastColumnId) {
            this.addSchemaInternal(schema, newLastColumnId);
            return this;
        }

        public Builder setDefaultPartitionSpec(PartitionSpec spec) {
            this.setDefaultPartitionSpec(this.addPartitionSpecInternal(spec));
            return this;
        }

        public Builder setDefaultPartitionSpec(int specId) {
            if (specId == -1) {
                ValidationException.check((this.lastAddedSpecId != null ? 1 : 0) != 0, (String)"Cannot set last added spec: no spec has been added", (Object[])new Object[0]);
                return this.setDefaultPartitionSpec(this.lastAddedSpecId);
            }
            if (this.defaultSpecId == specId) {
                return this;
            }
            this.defaultSpecId = specId;
            if (this.lastAddedSpecId != null && this.lastAddedSpecId == specId) {
                this.changes.add(new MetadataUpdate.SetDefaultPartitionSpec(-1));
            } else {
                this.changes.add(new MetadataUpdate.SetDefaultPartitionSpec(specId));
            }
            return this;
        }

        public Builder addPartitionSpec(UnboundPartitionSpec spec) {
            this.addPartitionSpecInternal(spec.bind(this.schemasById.get(this.currentSchemaId)));
            return this;
        }

        public Builder addPartitionSpec(PartitionSpec spec) {
            this.addPartitionSpecInternal(spec);
            return this;
        }

        public Builder setDefaultSortOrder(SortOrder order) {
            this.setDefaultSortOrder(this.addSortOrderInternal(order));
            return this;
        }

        public Builder setDefaultSortOrder(int sortOrderId) {
            if (sortOrderId == -1) {
                ValidationException.check((this.lastAddedOrderId != null ? 1 : 0) != 0, (String)"Cannot set last added sort order: no sort order has been added", (Object[])new Object[0]);
                return this.setDefaultSortOrder(this.lastAddedOrderId);
            }
            if (sortOrderId == this.defaultSortOrderId) {
                return this;
            }
            this.defaultSortOrderId = sortOrderId;
            if (this.lastAddedOrderId != null && this.lastAddedOrderId == sortOrderId) {
                this.changes.add(new MetadataUpdate.SetDefaultSortOrder(-1));
            } else {
                this.changes.add(new MetadataUpdate.SetDefaultSortOrder(sortOrderId));
            }
            return this;
        }

        public Builder addSortOrder(UnboundSortOrder order) {
            this.addSortOrderInternal(order.bind(this.schemasById.get(this.currentSchemaId)));
            return this;
        }

        public Builder addSortOrder(SortOrder order) {
            this.addSortOrderInternal(order);
            return this;
        }

        public Builder addSnapshot(Snapshot snapshot) {
            if (snapshot == null) {
                return this;
            }
            ValidationException.check((!this.schemas.isEmpty() ? 1 : 0) != 0, (String)"Attempting to add a snapshot before a schema is added", (Object[])new Object[0]);
            ValidationException.check((!this.specs.isEmpty() ? 1 : 0) != 0, (String)"Attempting to add a snapshot before a partition spec is added", (Object[])new Object[0]);
            ValidationException.check((!this.sortOrders.isEmpty() ? 1 : 0) != 0, (String)"Attempting to add a snapshot before a sort order is added", (Object[])new Object[0]);
            ValidationException.check((!this.snapshotsById.containsKey(snapshot.snapshotId()) ? 1 : 0) != 0, (String)"Snapshot already exists for id: %s", (Object[])new Object[]{snapshot.snapshotId()});
            ValidationException.check((this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber ? 1 : 0) != 0, (String)"Cannot add snapshot with sequence number %s older than last sequence number %s", (Object[])new Object[]{snapshot.sequenceNumber(), this.lastSequenceNumber});
            this.lastUpdatedMillis = snapshot.timestampMillis();
            this.lastSequenceNumber = snapshot.sequenceNumber();
            this.snapshots.add(snapshot);
            this.snapshotsById.put(snapshot.snapshotId(), snapshot);
            this.changes.add(new MetadataUpdate.AddSnapshot(snapshot));
            return this;
        }

        public Builder setSnapshotsSupplier(SerializableSupplier<List<Snapshot>> snapshotsSupplier) {
            this.snapshotsSupplier = snapshotsSupplier;
            return this;
        }

        public Builder setBranchSnapshot(Snapshot snapshot, String branch) {
            this.addSnapshot(snapshot);
            this.setBranchSnapshotInternal(snapshot, branch);
            return this;
        }

        public Builder setBranchSnapshot(long snapshotId, String branch) {
            SnapshotRef ref = this.refs.get(branch);
            if (ref != null && ref.snapshotId() == snapshotId) {
                return this;
            }
            Snapshot snapshot = this.snapshotsById.get(snapshotId);
            ValidationException.check((snapshot != null ? 1 : 0) != 0, (String)"Cannot set %s to unknown snapshot: %s", (Object[])new Object[]{branch, snapshotId});
            this.setBranchSnapshotInternal(snapshot, branch);
            return this;
        }

        public Builder setRef(String name, SnapshotRef ref) {
            SnapshotRef existingRef = this.refs.get(name);
            if (existingRef != null && existingRef.equals((Object)ref)) {
                return this;
            }
            long snapshotId = ref.snapshotId();
            Snapshot snapshot = this.snapshotsById.get(snapshotId);
            ValidationException.check((snapshot != null ? 1 : 0) != 0, (String)"Cannot set %s to unknown snapshot: %s", (Object[])new Object[]{name, snapshotId});
            if (this.isAddedSnapshot(snapshotId)) {
                this.lastUpdatedMillis = snapshot.timestampMillis();
            }
            if ("main".equals(name)) {
                this.currentSnapshotId = ref.snapshotId();
                if (this.lastUpdatedMillis == null) {
                    this.lastUpdatedMillis = System.currentTimeMillis();
                }
                this.snapshotLog.add(new SnapshotLogEntry(this.lastUpdatedMillis, ref.snapshotId()));
            }
            this.refs.put(name, ref);
            MetadataUpdate.SetSnapshotRef refUpdate = new MetadataUpdate.SetSnapshotRef(name, ref.snapshotId(), ref.type(), ref.minSnapshotsToKeep(), ref.maxSnapshotAgeMs(), ref.maxRefAgeMs());
            this.changes.add(refUpdate);
            return this;
        }

        public Builder removeRef(String name) {
            SnapshotRef ref;
            if ("main".equals(name)) {
                this.currentSnapshotId = -1L;
                this.snapshotLog.clear();
            }
            if ((ref = this.refs.remove(name)) != null) {
                this.changes.add(new MetadataUpdate.RemoveSnapshotRef(name));
            }
            return this;
        }

        public Builder setStatistics(long snapshotId, StatisticsFile statisticsFile) {
            Preconditions.checkNotNull((Object)statisticsFile, (Object)"statisticsFile is null");
            Preconditions.checkArgument((snapshotId == statisticsFile.snapshotId() ? 1 : 0) != 0, (String)"snapshotId does not match: %s vs %s", (long)snapshotId, (long)statisticsFile.snapshotId());
            this.statisticsFiles.put(statisticsFile.snapshotId(), (List<StatisticsFile>)ImmutableList.of((Object)statisticsFile));
            this.changes.add(new MetadataUpdate.SetStatistics(snapshotId, statisticsFile));
            return this;
        }

        public Builder removeStatistics(long snapshotId) {
            Preconditions.checkNotNull((Object)snapshotId, (Object)"snapshotId is null");
            if (this.statisticsFiles.remove(snapshotId) == null) {
                return this;
            }
            this.changes.add(new MetadataUpdate.RemoveStatistics(snapshotId));
            return this;
        }

        public Builder removeSnapshots(List<Snapshot> snapshotsToRemove) {
            Set<Long> idsToRemove = snapshotsToRemove.stream().map(Snapshot::snapshotId).collect(Collectors.toSet());
            return this.removeSnapshots(idsToRemove);
        }

        public Builder removeSnapshots(Collection<Long> idsToRemove) {
            ArrayList retainedSnapshots = Lists.newArrayListWithExpectedSize((int)(this.snapshots.size() - idsToRemove.size()));
            for (Snapshot snapshot : this.snapshots) {
                long snapshotId = snapshot.snapshotId();
                if (idsToRemove.contains(snapshotId)) {
                    this.snapshotsById.remove(snapshotId);
                    this.changes.add(new MetadataUpdate.RemoveSnapshot(snapshotId));
                    this.removeStatistics(snapshotId);
                    continue;
                }
                retainedSnapshots.add(snapshot);
            }
            this.snapshots = retainedSnapshots;
            HashSet danglingRefs = Sets.newHashSet();
            for (Map.Entry<String, SnapshotRef> refEntry : this.refs.entrySet()) {
                if (this.snapshotsById.containsKey(refEntry.getValue().snapshotId())) continue;
                danglingRefs.add(refEntry.getKey());
            }
            danglingRefs.forEach(this::removeRef);
            return this;
        }

        public Builder setProperties(Map<String, String> updated) {
            if (updated.isEmpty()) {
                return this;
            }
            this.properties.putAll(updated);
            this.changes.add(new MetadataUpdate.SetProperties(updated));
            return this;
        }

        public Builder removeProperties(Set<String> removed) {
            if (removed.isEmpty()) {
                return this;
            }
            removed.forEach(this.properties::remove);
            this.changes.add(new MetadataUpdate.RemoveProperties(removed));
            return this;
        }

        public Builder setLocation(String newLocation) {
            if (this.location != null && this.location.equals(newLocation)) {
                return this;
            }
            this.location = newLocation;
            this.changes.add(new MetadataUpdate.SetLocation(newLocation));
            return this;
        }

        public Builder discardChanges() {
            this.discardChanges = true;
            return this;
        }

        public Builder setPreviousFileLocation(String previousFileLocation) {
            this.previousFileLocation = previousFileLocation;
            return this;
        }

        private boolean hasChanges() {
            return this.changes.size() != this.startingChangeCount || this.discardChanges && this.changes.size() > 0 || this.metadataLocation != null;
        }

        public TableMetadata build() {
            if (!this.hasChanges()) {
                return this.base;
            }
            if (this.lastUpdatedMillis == null) {
                this.lastUpdatedMillis = System.currentTimeMillis();
            }
            Preconditions.checkArgument((this.changes.size() == 0 || this.discardChanges || this.metadataLocation == null ? 1 : 0) != 0, (String)"Cannot set metadata location with changes to table metadata: %s changes", (int)this.changes.size());
            Schema schema = this.schemasById.get(this.currentSchemaId);
            PartitionSpec.checkCompatibility((PartitionSpec)this.specsById.get(this.defaultSpecId), (Schema)schema);
            SortOrder.checkCompatibility((SortOrder)this.sortOrdersById.get(this.defaultSortOrderId), (Schema)schema);
            List<Object> metadataHistory = this.base == null ? Lists.newArrayList() : Builder.addPreviousFile(this.previousFiles, this.previousFileLocation, this.base.lastUpdatedMillis(), this.properties);
            List<HistoryEntry> newSnapshotLog = Builder.updateSnapshotLog(this.snapshotLog, this.snapshotsById, this.currentSnapshotId, this.changes);
            return new TableMetadata(this.metadataLocation, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, this.lastUpdatedMillis, this.lastColumnId, this.currentSchemaId, (List<Schema>)ImmutableList.copyOf(this.schemas), this.defaultSpecId, (List<PartitionSpec>)ImmutableList.copyOf(this.specs), this.lastAssignedPartitionId, this.defaultSortOrderId, (List<SortOrder>)ImmutableList.copyOf(this.sortOrders), (Map<String, String>)ImmutableMap.copyOf(this.properties), this.currentSnapshotId, (List<Snapshot>)ImmutableList.copyOf(this.snapshots), this.snapshotsSupplier, (List<HistoryEntry>)ImmutableList.copyOf(newSnapshotLog), (List<MetadataLogEntry>)ImmutableList.copyOf((Collection)metadataHistory), (Map<String, SnapshotRef>)ImmutableMap.copyOf(this.refs), this.statisticsFiles.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), (List<MetadataUpdate>)(this.discardChanges ? ImmutableList.of() : ImmutableList.copyOf(this.changes)));
        }

        private int addSchemaInternal(Schema schema, int newLastColumnId) {
            Preconditions.checkArgument((newLastColumnId >= this.lastColumnId ? 1 : 0) != 0, (String)"Invalid last column ID: %s < %s (previous last column ID)", (int)newLastColumnId, (int)this.lastColumnId);
            int newSchemaId = this.reuseOrCreateNewSchemaId(schema);
            boolean schemaFound = this.schemasById.containsKey(newSchemaId);
            if (schemaFound && newLastColumnId == this.lastColumnId) {
                boolean isNewSchema = this.lastAddedSchemaId != null && this.changes(MetadataUpdate.AddSchema.class).anyMatch(added -> added.schema().schemaId() == newSchemaId);
                this.lastAddedSchemaId = isNewSchema ? Integer.valueOf(newSchemaId) : null;
                return newSchemaId;
            }
            this.lastColumnId = newLastColumnId;
            Schema newSchema = newSchemaId != schema.schemaId() ? new Schema(newSchemaId, schema.columns(), schema.identifierFieldIds()) : schema;
            if (!schemaFound) {
                this.schemas.add(newSchema);
                this.schemasById.put(newSchema.schemaId(), newSchema);
            }
            this.changes.add(new MetadataUpdate.AddSchema(newSchema, this.lastColumnId));
            this.lastAddedSchemaId = newSchemaId;
            return newSchemaId;
        }

        private int reuseOrCreateNewSchemaId(Schema newSchema) {
            int newSchemaId = this.currentSchemaId;
            for (Schema schema : this.schemas) {
                if (schema.sameSchema(newSchema)) {
                    return schema.schemaId();
                }
                if (schema.schemaId() < newSchemaId) continue;
                newSchemaId = schema.schemaId() + 1;
            }
            return newSchemaId;
        }

        private int addPartitionSpecInternal(PartitionSpec spec) {
            int newSpecId = this.reuseOrCreateNewSpecId(spec);
            if (this.specsById.containsKey(newSpecId)) {
                boolean isNewSpec = this.lastAddedSpecId != null && this.changes(MetadataUpdate.AddPartitionSpec.class).anyMatch(added -> added.spec().specId() == this.lastAddedSpecId.intValue());
                this.lastAddedSpecId = isNewSpec ? Integer.valueOf(newSpecId) : null;
                return newSpecId;
            }
            Schema schema = this.schemasById.get(this.currentSchemaId);
            PartitionSpec.checkCompatibility((PartitionSpec)spec, (Schema)schema);
            ValidationException.check((this.formatVersion > 1 || PartitionSpec.hasSequentialIds((PartitionSpec)spec) ? 1 : 0) != 0, (String)"Spec does not use sequential IDs that are required in v1: %s", (Object[])new Object[]{spec});
            PartitionSpec newSpec = TableMetadata.freshSpec(newSpecId, schema, spec);
            this.lastAssignedPartitionId = Math.max(this.lastAssignedPartitionId, newSpec.lastAssignedFieldId());
            this.specs.add(newSpec);
            this.specsById.put(newSpecId, newSpec);
            this.changes.add(new MetadataUpdate.AddPartitionSpec(newSpec));
            this.lastAddedSpecId = newSpecId;
            return newSpecId;
        }

        private int reuseOrCreateNewSpecId(PartitionSpec newSpec) {
            int newSpecId = 0;
            for (PartitionSpec spec : this.specs) {
                if (newSpec.compatibleWith(spec)) {
                    return spec.specId();
                }
                if (newSpecId > spec.specId()) continue;
                newSpecId = spec.specId() + 1;
            }
            return newSpecId;
        }

        private int addSortOrderInternal(SortOrder order) {
            int newOrderId = this.reuseOrCreateNewSortOrderId(order);
            if (this.sortOrdersById.containsKey(newOrderId)) {
                boolean isNewOrder = this.lastAddedOrderId != null && this.changes(MetadataUpdate.AddSortOrder.class).anyMatch(added -> added.sortOrder().orderId() == this.lastAddedOrderId.intValue());
                this.lastAddedOrderId = isNewOrder ? Integer.valueOf(newOrderId) : null;
                return newOrderId;
            }
            Schema schema = this.schemasById.get(this.currentSchemaId);
            SortOrder.checkCompatibility((SortOrder)order, (Schema)schema);
            SortOrder newOrder = order.isUnsorted() ? SortOrder.unsorted() : TableMetadata.freshSortOrder(newOrderId, schema, order);
            this.sortOrders.add(newOrder);
            this.sortOrdersById.put(newOrderId, newOrder);
            this.changes.add(new MetadataUpdate.AddSortOrder(newOrder));
            this.lastAddedOrderId = newOrderId;
            return newOrderId;
        }

        private int reuseOrCreateNewSortOrderId(SortOrder newOrder) {
            if (newOrder.isUnsorted()) {
                return SortOrder.unsorted().orderId();
            }
            int newOrderId = 1;
            for (SortOrder order : this.sortOrders) {
                if (order.sameOrder(newOrder)) {
                    return order.orderId();
                }
                if (newOrderId > order.orderId()) continue;
                newOrderId = order.orderId() + 1;
            }
            return newOrderId;
        }

        private void setBranchSnapshotInternal(Snapshot snapshot, String branch) {
            long replacementSnapshotId = snapshot.snapshotId();
            SnapshotRef ref = this.refs.get(branch);
            if (ref != null) {
                ValidationException.check((boolean)ref.isBranch(), (String)"Cannot update branch: %s is a tag", (Object[])new Object[]{branch});
                if (ref.snapshotId() == replacementSnapshotId) {
                    return;
                }
            }
            ValidationException.check((this.formatVersion == 1 || snapshot.sequenceNumber() <= this.lastSequenceNumber ? 1 : 0) != 0, (String)"Last sequence number %s is less than existing snapshot sequence number %s", (Object[])new Object[]{this.lastSequenceNumber, snapshot.sequenceNumber()});
            SnapshotRef newRef = ref != null ? SnapshotRef.builderFrom((SnapshotRef)ref, (long)replacementSnapshotId).build() : SnapshotRef.branchBuilder((long)replacementSnapshotId).build();
            this.setRef(branch, newRef);
        }

        private static List<MetadataLogEntry> addPreviousFile(List<MetadataLogEntry> previousFiles, String previousFileLocation, long timestampMillis, Map<String, String> properties) {
            ArrayList newMetadataLog;
            if (previousFileLocation == null) {
                return previousFiles;
            }
            int maxSize = Math.max(1, PropertyUtil.propertyAsInt(properties, "write.metadata.previous-versions-max", 100));
            if (previousFiles.size() >= maxSize) {
                int removeIndex = previousFiles.size() - maxSize + 1;
                newMetadataLog = Lists.newArrayList(previousFiles.subList(removeIndex, previousFiles.size()));
            } else {
                newMetadataLog = Lists.newArrayList(previousFiles);
            }
            newMetadataLog.add(new MetadataLogEntry(timestampMillis, previousFileLocation));
            return newMetadataLog;
        }

        private static Set<Long> intermediateSnapshotIdSet(List<MetadataUpdate> changes, long currentSnapshotId) {
            HashSet addedSnapshotIds = Sets.newHashSet();
            HashSet intermediateSnapshotIds = Sets.newHashSet();
            for (MetadataUpdate update : changes) {
                MetadataUpdate.SetSnapshotRef setRef;
                long snapshotId;
                if (update instanceof MetadataUpdate.AddSnapshot) {
                    MetadataUpdate.AddSnapshot addSnapshot = (MetadataUpdate.AddSnapshot)update;
                    addedSnapshotIds.add(addSnapshot.snapshot().snapshotId());
                    continue;
                }
                if (!(update instanceof MetadataUpdate.SetSnapshotRef) || !addedSnapshotIds.contains(snapshotId = (setRef = (MetadataUpdate.SetSnapshotRef)update).snapshotId()) || !"main".equals(setRef.name()) || snapshotId == currentSnapshotId) continue;
                intermediateSnapshotIds.add(snapshotId);
            }
            return intermediateSnapshotIds;
        }

        private static List<HistoryEntry> updateSnapshotLog(List<HistoryEntry> snapshotLog, Map<Long, Snapshot> snapshotsById, long currentSnapshotId, List<MetadataUpdate> changes) {
            Set<Long> intermediateSnapshotIds = Builder.intermediateSnapshotIdSet(changes, currentSnapshotId);
            ArrayList newSnapshotLog = Lists.newArrayList();
            for (HistoryEntry logEntry : snapshotLog) {
                long snapshotId = logEntry.snapshotId();
                if (snapshotsById.containsKey(snapshotId)) {
                    if (intermediateSnapshotIds.contains(snapshotId)) continue;
                    newSnapshotLog.add(logEntry);
                    continue;
                }
                newSnapshotLog.clear();
            }
            if (snapshotsById.get(currentSnapshotId) != null) {
                ValidationException.check((((HistoryEntry)Iterables.getLast((Iterable)newSnapshotLog)).snapshotId() == currentSnapshotId ? 1 : 0) != 0, (String)"Cannot set invalid snapshot log: latest entry is not the current snapshot", (Object[])new Object[0]);
            }
            return newSnapshotLog;
        }

        private boolean isAddedSnapshot(long snapshotId) {
            return this.changes(MetadataUpdate.AddSnapshot.class).anyMatch(add -> add.snapshot().snapshotId() == snapshotId);
        }

        private <U extends MetadataUpdate> Stream<U> changes(Class<U> updateClass) {
            return this.changes.stream().filter(updateClass::isInstance).map(updateClass::cast);
        }
    }

    public static class MetadataLogEntry {
        private final long timestampMillis;
        private final String file;

        MetadataLogEntry(long timestampMillis, String file) {
            this.timestampMillis = timestampMillis;
            this.file = file;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public String file() {
            return this.file;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetadataLogEntry)) {
                return false;
            }
            MetadataLogEntry that = (MetadataLogEntry)other;
            return this.timestampMillis == that.timestampMillis && java.util.Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestampMillis, this.file});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).add("file", (Object)this.file).toString();
        }
    }

    public static class SnapshotLogEntry
    implements HistoryEntry {
        private final long timestampMillis;
        private final long snapshotId;

        SnapshotLogEntry(long timestampMillis, long snapshotId) {
            this.timestampMillis = timestampMillis;
            this.snapshotId = snapshotId;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotLogEntry)) {
                return false;
            }
            SnapshotLogEntry that = (SnapshotLogEntry)other;
            return this.timestampMillis == that.timestampMillis && this.snapshotId == that.snapshotId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestampMillis, this.snapshotId});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).add("snapshotId", this.snapshotId).toString();
        }
    }
}

