/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableScanReport;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnapshotScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
extends BaseScan<ThisT, T, G> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotScan.class);
    private ScanMetrics scanMetrics;

    protected SnapshotScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    protected Long snapshotId() {
        return this.context().snapshotId();
    }

    protected abstract CloseableIterable<T> doPlanFiles();

    protected ScanMetrics scanMetrics() {
        if (this.scanMetrics == null) {
            this.scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        }
        return this.scanMetrics;
    }

    public ThisT useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set snapshot id=%s", (Object)this.snapshotId());
        Preconditions.checkArgument((this.table().snapshot(scanSnapshotId) != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s", (long)scanSnapshotId);
        return this.newRefinedScan(this.table(), this.tableSchema(), this.context().useSnapshotId(scanSnapshotId));
    }

    public ThisT useRef(String name) {
        if ("main".equals(name)) {
            return this.newRefinedScan(this.table(), this.tableSchema(), this.context());
        }
        Preconditions.checkArgument((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override ref, already set snapshot id=%s", (Object)this.snapshotId());
        Snapshot snapshot = this.table().snapshot(name);
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Cannot find ref %s", (Object)name);
        TableScanContext newContext = this.context().useSnapshotId(snapshot.snapshotId());
        return this.newRefinedScan(this.table(), SnapshotUtil.schemaFor(this.table(), name), newContext);
    }

    public ThisT asOfTime(long timestampMillis) {
        Preconditions.checkArgument((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set snapshot id=%s", (Object)this.snapshotId());
        return this.useSnapshot(SnapshotUtil.snapshotIdAsOfTime(this.table(), timestampMillis));
    }

    public CloseableIterable<T> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot == null) {
            LOG.info("Scanning empty table {}", (Object)this.table());
            return CloseableIterable.empty();
        }
        LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table(), snapshot.snapshotId(), DateTimeUtil.formatTimestampMillis((long)snapshot.timestampMillis()), ExpressionUtil.toSanitizedString((Expression)this.filter())});
        Listeners.notifyAll((Object)new ScanEvent(this.table().name(), snapshot.snapshotId(), this.filter(), this.schema()));
        ArrayList projectedFieldIds = Lists.newArrayList((Iterable)TypeUtil.getProjectedIds((Schema)this.schema()));
        List projectedFieldNames = projectedFieldIds.stream().map(arg_0 -> ((Schema)this.schema()).findColumnName(arg_0)).collect(Collectors.toList());
        Timer.Timed planningDuration = this.scanMetrics().totalPlanningDuration().start();
        return CloseableIterable.whenComplete(this.doPlanFiles(), () -> {
            planningDuration.stop();
            HashMap metadata = Maps.newHashMap(this.context().options());
            metadata.putAll(EnvironmentContext.get());
            ImmutableScanReport scanReport = ImmutableScanReport.builder().schemaId(this.schema().schemaId()).projectedFieldIds(projectedFieldIds).projectedFieldNames(projectedFieldNames).tableName(this.table().name()).snapshotId(snapshot.snapshotId()).filter(ExpressionUtil.sanitize((Expression)this.filter())).scanMetrics(ScanMetricsResult.fromScanMetrics(this.scanMetrics())).metadata(metadata).build();
            this.context().metricsReporter().report((MetricsReport)scanReport);
        });
    }

    public Snapshot snapshot() {
        return this.snapshotId() != null ? this.table().snapshot(this.snapshotId().longValue()) : this.table().currentSnapshot();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table()).add("projection", (Object)this.schema().asStruct()).add("filter", (Object)this.filter()).add("ignoreResiduals", this.shouldIgnoreResiduals()).add("caseSensitive", this.isCaseSensitive()).toString();
    }
}

