/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import io.airlift.slice.SizeOf;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public final class JdbcColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(JdbcColumnHandle.class);
    private final String columnName;
    private final JdbcTypeHandle jdbcTypeHandle;
    private final Type columnType;
    private final boolean nullable;
    private final Optional<String> comment;

    public JdbcColumnHandle(String columnName, JdbcTypeHandle jdbcTypeHandle, Type columnType) {
        this(columnName, jdbcTypeHandle, columnType, true, Optional.empty());
    }

    @Deprecated
    @JsonCreator
    public JdbcColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="jdbcTypeHandle") JdbcTypeHandle jdbcTypeHandle, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="nullable") boolean nullable, @JsonProperty(value="comment") Optional<String> comment) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jdbcTypeHandle = Objects.requireNonNull(jdbcTypeHandle, "jdbcTypeHandle is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.nullable = nullable;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public JdbcTypeHandle getJdbcTypeHandle() {
        return this.jdbcTypeHandle;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public boolean isNullable() {
        return this.nullable;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.columnName).setType(this.columnType).setNullable(this.nullable).setComment(this.comment).build();
    }

    public ColumnSchema getColumnSchema() {
        return ColumnSchema.builder().setName(this.columnName).setType(this.columnType).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnHandle o = (JdbcColumnHandle)obj;
        return Objects.equals(this.columnName, o.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return Joiner.on((String)":").skipNulls().join((Object)this.columnName, (Object)this.columnType.getDisplayName(), new Object[]{this.jdbcTypeHandle.getJdbcTypeName().orElse(null)});
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Boolean)this.nullable) + SizeOf.estimatedSizeOf((String)this.columnName) + SizeOf.sizeOf(this.comment, SizeOf::estimatedSizeOf) + this.jdbcTypeHandle.getRetainedSizeInBytes();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(JdbcColumnHandle handle) {
        return new Builder(handle);
    }

    public static final class Builder {
        private String columnName;
        private JdbcTypeHandle jdbcTypeHandle;
        private Type columnType;
        private boolean nullable = true;
        private Optional<String> comment = Optional.empty();

        public Builder() {
        }

        private Builder(JdbcColumnHandle handle) {
            this.columnName = handle.getColumnName();
            this.jdbcTypeHandle = handle.getJdbcTypeHandle();
            this.columnType = handle.getColumnType();
            this.nullable = handle.isNullable();
            this.comment = handle.getComment();
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setJdbcTypeHandle(JdbcTypeHandle jdbcTypeHandle) {
            this.jdbcTypeHandle = jdbcTypeHandle;
            return this;
        }

        public Builder setColumnType(Type columnType) {
            this.columnType = columnType;
            return this;
        }

        public Builder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setComment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        public JdbcColumnHandle build() {
            return new JdbcColumnHandle(this.columnName, this.jdbcTypeHandle, this.columnType, this.nullable, this.comment);
        }
    }
}

