/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class BlackHoleNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;

    public BlackHoleNodePartitioningProvider(TypeOperators typeOperators) {
        this.typeOperators = typeOperators;
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        List hashCodeInvokers = (List)partitionChannelTypes.stream().map(type -> this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}))).collect(ImmutableList.toImmutableList());
        return (page, position) -> {
            long hash = 13L;
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                Block block = page.getBlock(i);
                try {
                    long valueHash = block.isNull(position) ? 0L : ((MethodHandle)hashCodeInvokers.get(i)).invokeExact(block, position);
                    hash = 31L * hash + valueHash;
                    continue;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
            }
            return (int)((hash &= Long.MAX_VALUE) % (long)bucketCount);
        };
    }
}

