/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.ldap;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ldap.LdapClientModule;
import io.trino.plugin.password.ldap.LdapAuthenticator;
import io.trino.plugin.password.ldap.LdapAuthenticatorClient;
import io.trino.plugin.password.ldap.LdapAuthenticatorConfig;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.PasswordAuthenticatorFactory;
import java.util.Map;

public class LdapAuthenticatorFactory
implements PasswordAuthenticatorFactory {
    public String getName() {
        return "ldap";
    }

    public PasswordAuthenticator create(Map<String, String> config) {
        Bootstrap app = new Bootstrap(new Module[]{new LdapClientModule(), binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(LdapAuthenticatorConfig.class);
            binder.bind(LdapAuthenticatorClient.class).in(Scopes.SINGLETON);
            binder.bind(LdapAuthenticator.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (PasswordAuthenticator)injector.getInstance(LdapAuthenticator.class);
    }
}

