/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.file;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class FileConfig {
    private File passwordFile;
    private Duration refreshPeriod = new Duration(5.0, TimeUnit.SECONDS);
    private int authTokenCacheMaxSize = 1000;

    @NotNull
    @FileExists
    public File getPasswordFile() {
        return this.passwordFile;
    }

    @Config(value="file.password-file")
    @ConfigDescription(value="Location of the file that provides user names and passwords")
    public FileConfig setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    @Config(value="file.refresh-period")
    @ConfigDescription(value="How often to reload the password file")
    public FileConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    public int getAuthTokenCacheMaxSize() {
        return this.authTokenCacheMaxSize;
    }

    @Config(value="file.auth-token-cache.max-size")
    @ConfigDescription(value="Max number of cached authenticated passwords")
    public FileConfig setAuthTokenCacheMaxSize(int maxSize) {
        this.authTokenCacheMaxSize = maxSize;
        return this;
    }
}

