/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.google.sheets.SheetsConnectorTableHandle;
import java.util.Objects;

public final class SheetsSheetTableHandle
implements SheetsConnectorTableHandle {
    private final String sheetId;
    private final String sheetRange;

    @JsonCreator
    public SheetsSheetTableHandle(@JsonProperty(value="sheetId") String sheetId, @JsonProperty(value="sheetRange") String sheetRange) {
        this.sheetId = Objects.requireNonNull(sheetId, "sheetId is null");
        this.sheetRange = Objects.requireNonNull(sheetRange, "sheetRange is null");
    }

    @JsonProperty
    public String getSheetId() {
        return this.sheetId;
    }

    @JsonProperty
    public String getSheetRange() {
        return this.sheetRange;
    }

    @JsonIgnore
    public String getSheetExpression() {
        return "%s%s%s".formatted(this.sheetId, "#", this.sheetRange);
    }

    public String toString() {
        return String.format("Sheet[sheetId=%s, sheetRange=%s]", this.sheetId, this.sheetRange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SheetsSheetTableHandle that = (SheetsSheetTableHandle)o;
        return this.sheetId.equals(that.sheetId) && this.sheetRange.equals(that.sheetRange);
    }

    public int hashCode() {
        return Objects.hash(this.sheetId, this.sheetRange);
    }
}

