/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.lib.Interns;

@InterfaceAudience.Private
@.VisibleForTesting
public class MetricsCollectorImpl
implements MetricsCollector,
Iterable<MetricsRecordBuilderImpl> {
    private final List<MetricsRecordBuilderImpl> rbs = Lists.newArrayList();
    private MetricsFilter recordFilter;
    private MetricsFilter metricFilter;

    @Override
    public MetricsRecordBuilderImpl addRecord(MetricsInfo info) {
        boolean acceptable = this.recordFilter == null || this.recordFilter.accepts(info.name());
        MetricsRecordBuilderImpl rb = new MetricsRecordBuilderImpl(this, info, this.recordFilter, this.metricFilter, acceptable);
        if (acceptable) {
            this.rbs.add(rb);
        }
        return rb;
    }

    @Override
    public MetricsRecordBuilderImpl addRecord(String name) {
        return this.addRecord(Interns.info(name, name + " record"));
    }

    public List<MetricsRecordImpl> getRecords() {
        ArrayList<MetricsRecordImpl> recs = Lists.newArrayListWithCapacity(this.rbs.size());
        for (MetricsRecordBuilderImpl rb : this.rbs) {
            MetricsRecordImpl mr = rb.getRecord();
            if (mr == null) continue;
            recs.add(mr);
        }
        return recs;
    }

    @Override
    public Iterator<MetricsRecordBuilderImpl> iterator() {
        return this.rbs.iterator();
    }

    @InterfaceAudience.Private
    public void clear() {
        this.rbs.clear();
    }

    MetricsCollectorImpl setRecordFilter(MetricsFilter rf) {
        this.recordFilter = rf;
        return this;
    }

    MetricsCollectorImpl setMetricFilter(MetricsFilter mf) {
        this.metricFilter = mf;
        return this;
    }
}

