/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Master {
    public static String getMasterUserName(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            return conf.get("mapreduce.jobtracker.kerberos.principal");
        }
        return conf.get("yarn.resourcemanager.principal");
    }

    public static InetSocketAddress getMasterAddress(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            String masterAddress = conf.get("mapreduce.jobtracker.address", "localhost:8012");
            return NetUtils.createSocketAddr(masterAddress, 8012, "mapreduce.jobtracker.address");
        }
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterHostname = Master.getMasterAddress(conf).getHostName();
        return SecurityUtil.getServerPrincipal(Master.getMasterUserName(conf), masterHostname);
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

