/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.prestosql.hadoop.$internal.io.netty.channel.ChannelFutureListener;
import io.prestosql.hadoop.$internal.io.netty.channel.ChannelHandlerContext;
import io.prestosql.hadoop.$internal.io.netty.channel.SimpleChannelInboundHandler;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.DefaultHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpContent;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.LastHttpContent;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ExceptionHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.io.IOUtils;

class HdfsWriter
extends SimpleChannelInboundHandler<HttpContent> {
    private final DFSClient client;
    private final OutputStream out;
    private final DefaultHttpResponse response;
    private static final Log LOG = WebHdfsHandler.LOG;

    HdfsWriter(DFSClient client, OutputStream out, DefaultHttpResponse response) {
        this.client = client;
        this.out = out;
        this.response = response;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpContent chunk) throws IOException {
        chunk.content().readBytes(this.out, chunk.content().readableBytes());
        if (chunk instanceof LastHttpContent) {
            this.response.headers().set("Connection", (Object)"close");
            ctx.write(this.response).addListener(ChannelFutureListener.CLOSE);
            this.releaseDfsResources();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.releaseDfsResources();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.releaseDfsResources();
        DefaultFullHttpResponse resp = ExceptionHandler.exceptionCaught(cause);
        resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush(this.response).addListener(ChannelFutureListener.CLOSE);
    }

    private void releaseDfsResources() {
        IOUtils.cleanup(LOG, this.out);
        IOUtils.cleanup(LOG, this.client);
    }
}

